/*
 * Decompiled with CFR 0.152.
 */
package calhoun.analysis.crf.solver;

import calhoun.analysis.crf.CRFObjectiveFunctionGradient;
import calhoun.analysis.crf.CRFTraining;
import calhoun.analysis.crf.ModelManager;
import calhoun.analysis.crf.io.TrainingSequence;
import calhoun.util.ErrorException;
import cern.colt.matrix.impl.DenseDoubleMatrix1D;
import flanagan.math.Minimisation;
import flanagan.math.MinimisationFunction;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SimplexOptimizer
implements CRFTraining {
    private static final Log log = LogFactory.getLog(SimplexOptimizer.class);
    CRFObjectiveFunctionGradient gradFunc;
    int maxIters = 500;
    double stepSize = 0.5;
    boolean requireConvergence = true;
    double[] starts = null;

    @Override
    public double[] optimize(ModelManager fm, List<? extends TrainingSequence<?>> data) {
        this.gradFunc.setTrainingData(fm, data);
        final int nFeatures = fm.getNumFeatures();
        MinimisationFunction mFunc = new MinimisationFunction(){
            double[] grad;
            {
                this.grad = new double[nFeatures];
            }

            @Override
            public double function(double[] d) {
                return -SimplexOptimizer.this.gradFunc.apply(d, this.grad);
            }
        };
        Minimisation m = new Minimisation();
        DenseDoubleMatrix1D steps = new DenseDoubleMatrix1D(nFeatures);
        m.setNmax(this.maxIters);
        if (this.starts == null) {
            this.starts = new double[nFeatures];
            Arrays.fill(this.starts, 1.0);
        }
        steps.assign(this.stepSize);
        m.nelderMead(mFunc, this.starts, steps.toArray());
        if (this.requireConvergence && !m.getConvStatus()) {
            throw new ErrorException("Convergence not reached.");
        }
        return m.getParamValues();
    }

    public CRFObjectiveFunctionGradient getObjectiveFunction() {
        return this.gradFunc;
    }

    public void setObjectiveFunction(CRFObjectiveFunctionGradient objectiveFunction) {
        this.gradFunc = objectiveFunction;
    }

    public int getMaxIters() {
        return this.maxIters;
    }

    public void setMaxIters(int maxIters) {
        this.maxIters = maxIters;
    }

    public boolean isRequireConvergence() {
        return this.requireConvergence;
    }

    public void setRequireConvergence(boolean requireConvergence) {
        this.requireConvergence = requireConvergence;
    }

    public double[] getStarts() {
        return this.starts;
    }

    @Override
    public void setStarts(double[] starts) {
        this.starts = starts;
    }

    public double getStepSize() {
        return this.stepSize;
    }

    public void setStepSize(double stepSize) {
        this.stepSize = stepSize;
    }
}

