/*
 * Decompiled with CFR 0.152.
 */
package calhoun.analysis.crf.solver;

import calhoun.analysis.crf.CRFObjectiveFunctionGradient;
import calhoun.analysis.crf.CRFTraining;
import calhoun.analysis.crf.ModelManager;
import calhoun.analysis.crf.io.TrainingSequence;
import calhoun.util.Assert;
import calhoun.util.ErrorException;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import riso.numerical.LBFGS;

public class StandardOptimizer
implements CRFTraining {
    private static final Log log = LogFactory.getLog(StandardOptimizer.class);
    boolean debug = log.isDebugEnabled();
    CRFObjectiveFunctionGradient gradFunc;
    int maxIters = 2000;
    int mForHessian = 20;
    int debugLevel = 0;
    boolean requireConvergence = true;
    double epsForConvergence = 1.0E-5;
    double[] starts = null;
    boolean fixFirstWeight = false;
    double quadraticRegularization = 0.0;
    int unchangedObjective = 5;

    @Override
    public double[] optimize(ModelManager fm, List<? extends TrainingSequence<?>> data) {
        this.gradFunc.setTrainingData(fm, data);
        int nFeatures = fm.getNumFeatures();
        if (this.requireConvergence) {
            log.info((Object)"NOTE: You ARE requiring convergence of LBFGS");
        } else {
            log.warn((Object)"NOTE: You ARE NOT requiring convergence of LBFGS");
        }
        double f = Double.NaN;
        double xtol = 1.0E-16;
        int[] iprint = new int[]{this.debugLevel - 2, this.debugLevel - 1};
        int[] iflag = new int[]{0};
        int numFeatures = nFeatures;
        double[] lambda = new double[nFeatures];
        double[] grad = new double[nFeatures];
        if (this.fixFirstWeight) {
            log.info((Object)"Fixing first weight to 1.0.");
            --numFeatures;
        }
        double[] optLambda = new double[numFeatures];
        double[] optGrad = new double[numFeatures];
        double[] diag = new double[numFeatures];
        if (this.starts == null) {
            Arrays.fill(lambda, 1.0);
        } else {
            Assert.a(this.starts.length == lambda.length, "Received ", this.starts.length, " initial weights.  Expected: ", lambda.length);
            System.arraycopy(this.starts, 0, lambda, 0, lambda.length);
        }
        int icall = 0;
        float lastObjective = Float.NaN;
        int runningObjective = 0;
        do {
            int j;
            if (this.fixFirstWeight) {
                lambda[0] = 1.0;
            }
            try {
                f = this.gradFunc.apply(lambda, grad);
            }
            catch (RuntimeException ex) {
                if (this.requireConvergence) {
                    throw ex;
                }
                log.warn((Object)"Exception thrown while calculating gradient.  Possible numeric problem.");
                log.warn((Object)ex);
                return lambda;
            }
            f = -f;
            if (this.fixFirstWeight) {
                for (j = 1; j < lambda.length; ++j) {
                    optGrad[j - 1] = -grad[j];
                }
                for (j = 1; j < lambda.length; ++j) {
                    optLambda[j - 1] = lambda[j];
                }
            } else {
                for (j = 0; j < lambda.length; ++j) {
                    optGrad[j] = -grad[j];
                }
                for (j = 0; j < lambda.length; ++j) {
                    optLambda[j] = lambda[j];
                }
            }
            for (j = 0; j < lambda.length; ++j) {
                f += this.quadraticRegularization * lambda[j] * lambda[j];
                int n = j;
                optGrad[n] = optGrad[n] + 2.0 * this.quadraticRegularization * lambda[j];
            }
            if ((float)f == lastObjective) {
                log.info((Object)("Objective value unchanged: " + lastObjective + " returned " + ++runningObjective + " times."));
                if (runningObjective > 0 && runningObjective >= this.unchangedObjective) {
                    log.warn((Object)("Same objective value: " + lastObjective + " returned " + (this.unchangedObjective + 1) + " times.  Assuming convergence."));
                    return lambda;
                }
            } else {
                runningObjective = 0;
                lastObjective = (float)f;
            }
            try {
                LBFGS.gtol = 0.1;
                LBFGS.lbfgs((int)numFeatures, (int)this.mForHessian, (double[])optLambda, (double)f, (double[])optGrad, (boolean)false, (double[])diag, (int[])iprint, (double)this.epsForConvergence, (double)xtol, (int[])iflag);
            }
            catch (LBFGS.ExceptionWithIflag e) {
                if (this.requireConvergence) {
                    throw new ErrorException("lbfgs failed", e);
                }
                log.warn((Object)"Lbfgs failed, proceeding anyway", (Throwable)e);
                break;
            }
            if (this.fixFirstWeight) {
                for (j = 1; j < lambda.length; ++j) {
                    lambda[j] = optLambda[j - 1];
                }
            } else {
                for (j = 0; j < lambda.length; ++j) {
                    lambda[j] = optLambda[j];
                }
            }
        } while (iflag[0] != 0 && ++icall < this.maxIters);
        if (this.requireConvergence && iflag[0] != 0) {
            throw new ErrorException("Convergence not reached.");
        }
        return lambda;
    }

    public CRFObjectiveFunctionGradient getObjectiveFunction() {
        return this.gradFunc;
    }

    public void setObjectiveFunction(CRFObjectiveFunctionGradient objectiveFunction) {
        this.gradFunc = objectiveFunction;
    }

    public int getDebugLevel() {
        return this.debugLevel;
    }

    public void setDebugLevel(int debugLevel) {
        this.debugLevel = debugLevel;
    }

    public double getEpsForConvergence() {
        return this.epsForConvergence;
    }

    public void setEpsForConvergence(double epsForConvergence) {
        this.epsForConvergence = epsForConvergence;
    }

    public boolean isFixFirstWeight() {
        return this.fixFirstWeight;
    }

    public void setFixFirstWeight(boolean fixFirstWeight) {
        this.fixFirstWeight = fixFirstWeight;
    }

    public int getMaxIters() {
        return this.maxIters;
    }

    public void setMaxIters(int maxIters) {
        this.maxIters = maxIters;
    }

    public int getMForHessian() {
        return this.mForHessian;
    }

    public void setMForHessian(int forHessian) {
        this.mForHessian = forHessian;
    }

    public double getQuadraticRegularization() {
        return this.quadraticRegularization;
    }

    public void setQuadraticRegularization(double quadraticRegularization) {
        this.quadraticRegularization = quadraticRegularization;
    }

    public boolean isRequireConvergence() {
        return this.requireConvergence;
    }

    public void setRequireConvergence(boolean requireConvergence) {
        this.requireConvergence = requireConvergence;
    }

    public double[] getStarts() {
        return this.starts;
    }

    @Override
    public void setStarts(double[] starts) {
        this.starts = starts;
    }

    public int getUnchangedObjective() {
        return this.unchangedObjective;
    }

    public void setUnchangedObjective(int unchangedObjective) {
        this.unchangedObjective = unchangedObjective;
    }
}

