/*
 * Decompiled with CFR 0.152.
 */
package calhoun.analysis.crf.solver.check;

import calhoun.analysis.crf.FeatureList;
import calhoun.analysis.crf.ModelManager;
import calhoun.analysis.crf.io.InputSequence;
import calhoun.util.Assert;
import calhoun.util.ErrorException;
import cern.colt.matrix.DoubleMatrix1D;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ArrayFeatureList
implements FeatureList {
    private static final Log log = LogFactory.getLog(ArrayFeatureList.class);
    private static final boolean debug = log.isDebugEnabled();
    static final float GROW_RATE = 1.5f;
    private ModelManager manager;
    public boolean valid;
    public int[] indices;
    public double[] values;
    public int currentSize;

    public ArrayFeatureList(ModelManager manager) {
        this.manager = manager;
        int length = manager.getNumFeatures() + 1;
        if (debug) {
            log.debug((Object)("Creating feature list of size " + length));
        }
        this.indices = new int[length];
        this.values = new double[length];
        this.clear();
    }

    @Override
    public void addFeature(int index, double value) {
        if (Double.isInfinite(value) || Double.isNaN(value)) {
            Assert.a(false, "Feature #" + index + " returned " + value);
        }
        if (this.currentSize == this.values.length) {
            int oldLength = this.values.length;
            int newLength = (int)(1.5f * (float)oldLength + 1.0f);
            log.warn((Object)("Expanding feature list from " + this.currentSize + " to " + newLength));
            double[] newValues = new double[newLength];
            int[] newIndices = new int[newLength];
            System.arraycopy(this.values, 0, newValues, 0, oldLength);
            System.arraycopy(this.indices, 0, newIndices, 0, oldLength);
            this.values = newValues;
            this.indices = newIndices;
        }
        this.indices[this.currentSize] = index;
        this.values[this.currentSize] = value;
        ++this.currentSize;
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    @Override
    public void invalidate() {
        this.valid = false;
    }

    public void evaluateNode(InputSequence seq, int pos, int state) {
        this.clear();
        this.manager.evaluateNode(seq, pos, state, this);
    }

    public void evaluateEdge(InputSequence seq, int pos, int prevState, int state) {
        this.clear();
        this.manager.evaluateEdge(seq, pos, prevState, state, this);
    }

    public void evaluateNodeLength(InputSequence seq, int pos, int len, int state) {
        this.clear();
        this.manager.evaluateNodeLength(seq, pos, len, state, this);
    }

    public void evaluateEdgeLength(InputSequence seq, int pos, int len, int prevState, int state) {
        this.clear();
        this.manager.evaluateEdgeLength(seq, pos, len, prevState, state, this);
    }

    public void clear() {
        this.valid = true;
        this.currentSize = 0;
    }

    public int getIndex(int index) {
        Assert.a(index < this.currentSize);
        return this.indices[index];
    }

    public double getValue(int index) {
        Assert.a(index < this.currentSize);
        return this.values[index];
    }

    public int[] getIndices() {
        return this.indices;
    }

    public double[] getValues() {
        return this.values;
    }

    public int size() {
        return this.currentSize;
    }

    public void updateExpectations(DoubleMatrix1D expects, double multiplier) {
        int size = this.size();
        for (int feat = 0; feat < size; ++feat) {
            int index = this.indices[feat];
            double val = this.values[feat] * multiplier;
            expects.setQuick(index, val + expects.getQuick(index));
            if (!Double.isNaN(val)) continue;
            throw new ErrorException("Overflow");
        }
    }
}

