/*
 * Decompiled with CFR 0.152.
 */
package calhoun.analysis.crf.solver.check;

import calhoun.analysis.crf.FeatureList;
import calhoun.analysis.crf.ModelManager;
import calhoun.analysis.crf.io.TrainingSequence;
import calhoun.analysis.crf.solver.check.TransitionInfo;
import calhoun.util.Assert;
import calhoun.util.CheckException;
import calhoun.util.ConfigException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FeatureCache
extends TransitionInfo {
    private static final Log log = LogFactory.getLog(FeatureCache.class);
    public short[] id;
    public byte[] potentialIx;
    public float[] val;
    public int longestSeq = 0;
    public int totalPositions = 0;
    public int totalFeatures = 0;
    public ArrayList<Short>[] constantId;
    public ArrayList<Float>[] constantVal;
    public int cachedFeatures = 0;
    public int numConstantFeatures = 0;
    public boolean[] invalidTransitions;
    public double[] featureSums;
    public int[] starts;
    public int[] seqOffsets;
    protected List<? extends TrainingSequence<?>> data;
    protected int nSeqs;

    public FeatureCache(ModelManager fm, List<? extends TrainingSequence<?>> data) {
        this(fm, data, false);
    }

    public FeatureCache(ModelManager fm, List<? extends TrainingSequence<?>> data, boolean allPaths) {
        this.init(fm, data, allPaths);
    }

    protected FeatureCache() {
    }

    protected void init(ModelManager fm, List<? extends TrainingSequence<?>> data, boolean allPaths) {
        this.initTrans(fm, allPaths);
        this.data = data;
        this.nSeqs = data.size();
        new ConstantFeatureList();
        this.totalFeatures = this.cachedFeatures + this.numConstantFeatures;
        new CachedFeatureList();
    }

    class ConstantFeatureList
    implements FeatureList {
        private boolean invalid;
        private int potentialIndex;
        private boolean[] initialized;
        private ArrayList<Integer> constantFeaturesToRemove = new ArrayList();
        private int expectedConstantIndex;
        private int featuresThisEval;
        private int previousPositions = 0;
        private int[] invalidCount;

        public ConstantFeatureList() {
            TrainingSequence<?> seq;
            int i;
            int nPotentials = FeatureCache.this.nStates + FeatureCache.this.nTransitions;
            FeatureCache.this.constantId = new ArrayList[nPotentials];
            FeatureCache.this.constantVal = new ArrayList[nPotentials];
            this.invalidCount = new int[nPotentials];
            this.initialized = new boolean[nPotentials];
            for (int i2 = 0; i2 < nPotentials; ++i2) {
                FeatureCache.this.constantId[i2] = new ArrayList();
                FeatureCache.this.constantVal[i2] = new ArrayList();
            }
            int totalLength = 0;
            for (i = 0; i < FeatureCache.this.nSeqs; ++i) {
                seq = FeatureCache.this.data.get(i);
                totalLength += seq.length();
            }
            FeatureCache.this.invalidTransitions = new boolean[totalLength * nPotentials];
            for (i = 0; i < FeatureCache.this.nSeqs; ++i) {
                seq = FeatureCache.this.data.get(i);
                int seqLen = seq.length();
                for (int j = 0; j < seqLen; ++j) {
                    for (short pot : FeatureCache.this.orderedPotentials) {
                        if (j == 0 && pot >= FeatureCache.this.nStates) continue;
                        this.checkPotential(seq, i, j, pot);
                    }
                }
                this.previousPositions += seq.length();
            }
            FeatureCache.this.totalPositions = this.previousPositions;
        }

        @Override
        public void addFeature(int index, double val) {
            if (this.invalid) {
                return;
            }
            float value = (float)val;
            if (!this.initialized[this.potentialIndex]) {
                FeatureCache.this.constantId[this.potentialIndex].add((short)index);
                FeatureCache.this.constantVal[this.potentialIndex].add(Float.valueOf(value));
            } else {
                int numConstants = FeatureCache.this.constantId[this.potentialIndex].size();
                if (this.expectedConstantIndex >= numConstants) {
                    ++this.featuresThisEval;
                } else if (FeatureCache.this.constantId[this.potentialIndex].get(this.expectedConstantIndex) == index && FeatureCache.this.constantVal[this.potentialIndex].get(this.expectedConstantIndex).floatValue() == value) {
                    ++this.expectedConstantIndex;
                } else {
                    int i;
                    boolean found = false;
                    for (i = this.expectedConstantIndex + 1; i < numConstants; ++i) {
                        if (FeatureCache.this.constantId[this.potentialIndex].get(i) != index || FeatureCache.this.constantVal[this.potentialIndex].get(i).floatValue() != value) continue;
                        found = true;
                        break;
                    }
                    if (found) {
                        for (int toRemove = this.expectedConstantIndex; toRemove < i; ++toRemove) {
                            this.constantFeaturesToRemove.add(toRemove);
                        }
                        this.expectedConstantIndex = i + 1;
                    } else {
                        ++this.featuresThisEval;
                    }
                }
            }
        }

        @Override
        public void invalidate() {
            this.invalid = true;
        }

        @Override
        public boolean isValid() {
            return !this.invalid;
        }

        void checkPotential(TrainingSequence seq, int seqNum, int pos, int potential) {
            boolean node = potential < FeatureCache.this.nStates;
            this.invalid = false;
            this.featuresThisEval = 0;
            this.expectedConstantIndex = 0;
            this.constantFeaturesToRemove.clear();
            if (node) {
                this.potentialIndex = potential;
                FeatureCache.this.fm.evaluateNode(seq, pos, potential, this);
            } else {
                this.potentialIndex = potential;
                FeatureCache.this.fm.evaluateEdge(seq, pos, FeatureCache.this.transitionFrom[potential - FeatureCache.this.nStates], FeatureCache.this.transitionTo[potential - FeatureCache.this.nStates], this);
            }
            if (this.invalid) {
                if (node) {
                    Assert.a(seq.getY(pos) != potential, "Seq: ", seqNum, " Pos: ", pos, ". Invalid state in training data: ", potential);
                } else {
                    Assert.a(seq.getY(pos - 1) != FeatureCache.this.transitionFrom[potential - FeatureCache.this.nStates] || seq.getY(pos) != FeatureCache.this.transitionTo[potential - FeatureCache.this.nStates], "Seq: ", seqNum, " Pos: ", pos, ". Invalid transition in training data: ", FeatureCache.this.transitionFrom[potential - FeatureCache.this.nStates], "-", FeatureCache.this.transitionTo[potential - FeatureCache.this.nStates]);
                }
                int n = this.potentialIndex;
                this.invalidCount[n] = this.invalidCount[n] + 1;
                this.featuresThisEval = 0;
                FeatureCache.this.invalidTransitions[(this.previousPositions + pos) * FeatureCache.this.nPotentials + this.potentialIndex] = true;
                if (!this.initialized[this.potentialIndex]) {
                    FeatureCache.this.constantId[this.potentialIndex].clear();
                    FeatureCache.this.constantVal[this.potentialIndex].clear();
                }
            } else if (!this.initialized[this.potentialIndex]) {
                FeatureCache.this.numConstantFeatures += FeatureCache.this.constantId[this.potentialIndex].size();
                log.debug((Object)String.format("Seq: %d Pos:%d, %d initial constant features for potential %d", seqNum, pos, FeatureCache.this.constantId[this.potentialIndex].size(), this.potentialIndex));
                this.initialized[this.potentialIndex] = true;
            } else {
                int constantSize = FeatureCache.this.constantId[this.potentialIndex].size();
                if (this.expectedConstantIndex != constantSize) {
                    Assert.a(this.expectedConstantIndex < constantSize);
                    for (int i = this.expectedConstantIndex; i < constantSize; ++i) {
                        this.constantFeaturesToRemove.add(i);
                    }
                }
                if (this.constantFeaturesToRemove.size() > 0) {
                    FeatureCache.this.numConstantFeatures -= this.constantFeaturesToRemove.size();
                    int newCachedFeatures = FeatureCache.this.cachedFeatures + this.constantFeaturesToRemove.size() * (this.previousPositions + pos - (node ? 0 : seqNum + 1) - this.invalidCount[this.potentialIndex]);
                    log.debug((Object)String.format("Seq: %d Pos: %d Potential: %d Removed %d constant features.  Cached features goes from %d to %d.", seqNum, pos, this.potentialIndex, this.constantFeaturesToRemove.size(), FeatureCache.this.cachedFeatures, newCachedFeatures));
                    FeatureCache.this.cachedFeatures = newCachedFeatures;
                    int count = 0;
                    for (Integer toRemove : this.constantFeaturesToRemove) {
                        int index = toRemove - count;
                        FeatureCache.this.constantId[this.potentialIndex].remove(index);
                        FeatureCache.this.constantVal[this.potentialIndex].remove(index);
                        ++count;
                    }
                    Assert.a(constantSize - this.constantFeaturesToRemove.size() == FeatureCache.this.constantId[this.potentialIndex].size(), String.format("Removed %d, went from %d to %d", this.constantFeaturesToRemove.size(), constantSize, FeatureCache.this.constantId[this.potentialIndex].size()));
                }
            }
            FeatureCache.this.cachedFeatures += this.featuresThisEval;
        }
    }

    class CachedFeatureList
    implements FeatureList {
        private int currentFeature;
        private int constantFeature;
        private int potentialIndex;
        private int previousPositions = 0;
        private byte prevState;
        private byte state;
        private boolean computeSum;

        public CachedFeatureList() {
            FeatureCache.this.featureSums = new double[FeatureCache.this.fm.getNumFeatures()];
            FeatureCache.this.seqOffsets = new int[FeatureCache.this.nSeqs + 1];
            FeatureCache.this.starts = new int[FeatureCache.this.totalPositions + 1];
            FeatureCache.this.starts[FeatureCache.this.totalPositions] = FeatureCache.this.totalFeatures;
            FeatureCache.this.id = new short[FeatureCache.this.totalFeatures];
            FeatureCache.this.potentialIx = new byte[FeatureCache.this.totalFeatures];
            FeatureCache.this.val = new float[FeatureCache.this.totalFeatures];
            this.currentFeature = 0;
            for (short potential : FeatureCache.this.orderedPotentials) {
                for (int j = 0; j < FeatureCache.this.constantId[potential].size(); ++j) {
                    FeatureCache.this.potentialIx[this.currentFeature] = (byte)potential;
                    FeatureCache.this.id[this.currentFeature] = FeatureCache.this.constantId[potential].get(j);
                    FeatureCache.this.val[this.currentFeature] = FeatureCache.this.constantVal[potential].get(j).floatValue();
                    ++this.currentFeature;
                }
            }
            FeatureCache.this.seqOffsets[0] = 0;
            for (int i = 0; i < FeatureCache.this.nSeqs; ++i) {
                TrainingSequence<?> seq = FeatureCache.this.data.get(i);
                int seqLen = seq.length();
                FeatureCache.this.longestSeq = Math.max(seqLen, FeatureCache.this.longestSeq);
                FeatureCache.this.seqOffsets[i + 1] = FeatureCache.this.seqOffsets[i] + seqLen;
                for (int pos = 0; pos < seqLen; ++pos) {
                    this.cachePosition(seq, i, pos);
                }
                this.previousPositions += seq.length();
            }
            Assert.a(this.currentFeature == FeatureCache.this.totalFeatures, "Current features: ", this.currentFeature, " Total Features: ", FeatureCache.this.totalFeatures);
            log.info((Object)String.format("Cached %d positions in %d sequences. %d features.  %d constant features.", FeatureCache.this.seqOffsets[FeatureCache.this.nSeqs], FeatureCache.this.nSeqs, FeatureCache.this.cachedFeatures, FeatureCache.this.numConstantFeatures));
        }

        void cachePosition(TrainingSequence seq, int i, int pos) {
            FeatureCache.this.starts[FeatureCache.this.seqOffsets[i] + pos] = this.currentFeature;
            byte trainingState = (byte)seq.getY(pos);
            byte trainingPrev = (byte)(pos == 0 ? -1 : seq.getY(pos - 1));
            int invalidIndex = (this.previousPositions + pos) * FeatureCache.this.nPotentials;
            for (int n : FeatureCache.this.orderedPotentials) {
                this.constantFeature = 0;
                this.potentialIndex = n;
                if (n < FeatureCache.this.nStates) {
                    this.computeSum = n == trainingState;
                    this.state = (byte)n;
                    this.prevState = (byte)-1;
                    if (FeatureCache.this.invalidTransitions[invalidIndex + this.state]) {
                        if (!this.computeSum) continue;
                        throw new ConfigException("Seq: " + i + " Pos: " + pos + ". Illegal state in training data: " + FeatureCache.this.fm.getStateName(trainingState));
                    }
                    FeatureCache.this.fm.evaluateNode(seq, pos, this.state, this);
                } else {
                    if (pos == 0) continue;
                    int trainingTransition = FeatureCache.this.transitionIndex.getQuick(trainingPrev, trainingState);
                    if (trainingTransition == -1) {
                        throw new ConfigException("Seq: " + i + " Pos: " + pos + ". Transition in training data that is disallowed in the model: " + FeatureCache.this.fm.getStateName(trainingPrev) + "-" + FeatureCache.this.fm.getStateName(trainingState));
                    }
                    int trans = n - FeatureCache.this.nStates;
                    this.computeSum = trans == trainingTransition;
                    this.prevState = (byte)FeatureCache.this.transitionFrom[trans];
                    this.state = (byte)FeatureCache.this.transitionTo[trans];
                    if (FeatureCache.this.invalidTransitions[invalidIndex + n]) {
                        if (!this.computeSum) continue;
                        throw new ConfigException("Seq: " + i + " Pos: " + pos + ". Transition in training data violated a constraint: " + FeatureCache.this.fm.getStateName(trainingPrev) + "-" + FeatureCache.this.fm.getStateName(trainingState));
                    }
                    FeatureCache.this.fm.evaluateEdge(seq, pos, this.prevState, this.state, this);
                }
                int expectedSize = FeatureCache.this.constantId[this.potentialIndex].size();
                Assert.a(this.constantFeature == expectedSize, "Pos: ", pos, " had ", this.constantFeature, " instead of ", expectedSize, " constant features.");
            }
        }

        @Override
        public void addFeature(int index, double doubleVal) {
            if (this.computeSum) {
                int n = index;
                FeatureCache.this.featureSums[n] = FeatureCache.this.featureSums[n] + doubleVal;
            }
            float value = (float)doubleVal;
            if (FeatureCache.this.constantId[this.potentialIndex].size() > this.constantFeature && FeatureCache.this.constantId[this.potentialIndex].get(this.constantFeature) == index && FeatureCache.this.constantVal[this.potentialIndex].get(this.constantFeature).floatValue() == value) {
                ++this.constantFeature;
                return;
            }
            FeatureCache.this.potentialIx[this.currentFeature] = (byte)this.potentialIndex;
            FeatureCache.this.id[this.currentFeature] = (short)index;
            FeatureCache.this.val[this.currentFeature] = value;
            ++this.currentFeature;
        }

        @Override
        public void invalidate() {
            throw new CheckException("A valid transition became an invalid transition during cache population.  Potential: " + this.potentialIndex);
        }

        @Override
        public boolean isValid() {
            return true;
        }
    }
}

