/*
 * Decompiled with CFR 0.152.
 */
package calhoun.analysis.crf.solver.check;

import calhoun.analysis.crf.ModelManager;
import calhoun.util.Assert;
import calhoun.util.DenseBooleanMatrix2D;
import calhoun.util.DenseIntMatrix2D;

public class TransitionInfo {
    public ModelManager fm;
    public short nStates;
    public int nTransitions;
    public int nPotentials;
    public short[] transitionFrom;
    public short[] transitionTo;
    public DenseIntMatrix2D transitionIndex;
    public short[] orderedPotentials;
    public boolean ignoreSemiMarkovSelf;

    public TransitionInfo(ModelManager fm, boolean allPaths) {
        this.initTrans(fm, allPaths);
    }

    protected TransitionInfo() {
    }

    protected boolean allowSelf(int state) {
        return false;
    }

    protected void initTrans(ModelManager argFm, boolean allPaths) {
        this.fm = argFm;
        this.nStates = (short)argFm.getNumStates();
        this.transitionIndex = new DenseIntMatrix2D(this.nStates, this.nStates);
        this.transitionIndex.assign(-1);
        DenseBooleanMatrix2D transitions = argFm.getLegalTransitions();
        if (transitions == null || allPaths) {
            transitions = new DenseBooleanMatrix2D(this.nStates, this.nStates);
            transitions.assign(true);
        }
        int count = 0;
        for (short i = 0; i < this.nStates; i = (short)(i + 1)) {
            Assert.a(this.ignoreSemiMarkovSelf || !this.allowSelf(i) || !transitions.getQuick(i, i), "Self transitions are not currently allowed in the semi-Markov model.  Set the 'ignoreSemiMarkovSelfTransitions' property of the CacheProcessor to true if you want to ignore this problem.  This is useful when using the same edge and transition set for a semi-markov and regular markov model.", i);
            for (short j = 0; j < this.nStates; j = (short)(j + 1)) {
                if (!transitions.getQuick(i, j) && (i != j || !this.allowSelf(i))) continue;
                count = (short)(count + 1);
            }
        }
        this.nTransitions = count;
        this.nPotentials = this.nStates + this.nTransitions;
        this.orderedPotentials = new short[this.nPotentials];
        this.transitionFrom = new short[this.nTransitions];
        this.transitionTo = new short[this.nTransitions];
        count = 0;
        int orderedCount = 0;
        for (short i = 0; i < this.nStates; i = (short)(i + 1)) {
            this.orderedPotentials[orderedCount] = i;
            ++orderedCount;
            for (short j = 0; j < this.nStates; j = (short)(j + 1)) {
                if (!transitions.getQuick(j, i) && (i != j || !this.allowSelf(i))) continue;
                this.orderedPotentials[orderedCount] = (short)(this.nStates + count);
                ++orderedCount;
                this.transitionIndex.setQuick(j, i, count);
                this.transitionFrom[count] = j;
                this.transitionTo[count] = i;
                count = (short)(count + 1);
            }
        }
        Assert.a(count == this.nTransitions);
    }
}

