/*
 * Decompiled with CFR 0.152.
 */
package calhoun.analysis.crf.test;

import calhoun.analysis.crf.Conrad;
import calhoun.analysis.crf.io.InputHandlerInterleaved;
import calhoun.analysis.crf.io.StringInput;
import calhoun.analysis.crf.io.TrainingSequence;
import calhoun.analysis.crf.solver.check.FeatureCache;
import calhoun.analysis.crf.test.ZeroOrderManager;
import calhoun.util.AbstractTestCase;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CacheTest
extends AbstractTestCase {
    private static final Log log = LogFactory.getLog(CacheTest.class);
    boolean debug = log.isDebugEnabled();

    public void testCache() throws Exception {
        this.doCache("test/input/zeroOrderModel.xml", "test/input/zeroOrderTrivial.txt", 0, 4);
        this.doCache("test/input/constraintModel.xml", "test/input/trivialGenes.txt", 0, 29);
        this.doCache("test/input/semiMarkovTestModelNoExplicitLengths.xml", "test/input/zeroOrderTrivial.txt", 30, 4);
    }

    public void testCacheHarder() throws Exception {
        List<? extends TrainingSequence<?>> data = new InputHandlerInterleaved(new StringInput()).readTrainingData("test/input/zeroOrderTest.txt");
        Conrad crf = ZeroOrderManager.getCRF();
        crf.trainFeatures(data);
        FeatureCache f = new FeatureCache(crf.getModel(), data);
        CacheTest.assertEquals((int)798, (int)f.cachedFeatures);
        CacheTest.assertEquals((int)4, (int)f.numConstantFeatures);
        CacheTest.assertEquals((int)802, (int)f.totalFeatures);
    }

    public void doCache(String model, String data, int cachedFeatures, int constantFeatures) throws Exception {
        Conrad r = new Conrad(model);
        r.trainFeatures(data);
        List<? extends TrainingSequence<?>> training = r.getInputHandler().readTrainingData(data);
        FeatureCache f = new FeatureCache(r.getModel(), training);
        CacheTest.assertEquals((int)cachedFeatures, (int)f.cachedFeatures);
        CacheTest.assertEquals((int)constantFeatures, (int)f.numConstantFeatures);
        CacheTest.assertEquals((int)(cachedFeatures + constantFeatures), (int)f.totalFeatures);
    }
}

