/*
 * Decompiled with CFR 0.152.
 */
package calhoun.analysis.crf.test;

import calhoun.analysis.crf.Conrad;
import calhoun.analysis.crf.io.InputHandlerInterleaved;
import calhoun.analysis.crf.io.OutputHandlerGeneCallStats;
import calhoun.analysis.crf.io.StringInput;
import calhoun.analysis.crf.io.TrainingSequence;
import calhoun.analysis.crf.test.CacheTest;
import calhoun.util.AbstractTestCase;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GTFWriterTest
extends AbstractTestCase {
    private static final Log log = LogFactory.getLog(CacheTest.class);
    boolean debug = log.isDebugEnabled();

    public void testWriteGTF() throws Exception {
        Conrad c = new Conrad("test/input/configGTF.xml");
        String gtfFile = "test/working/shortTrain.gtf";
        InputHandlerInterleaved ih = new InputHandlerInterleaved(new StringInput());
        List<? extends TrainingSequence<?>> data = ih.readTrainingData("test/input/shortTrain.tricycle13.txt");
        OutputHandlerGeneCallStats oh = new OutputHandlerGeneCallStats(c.getModel(), ih);
        oh.writeGTF(data, gtfFile);
        this.assertFilesMatch("test/output/shortTrain.gtf", gtfFile);
        gtfFile = "test/working/testGTF.gtf";
        List<? extends TrainingSequence<?>> data2 = c.getInputHandler().readTrainingData("test/input/testGTF.txt");
        oh = new OutputHandlerGeneCallStats(c.getModel(), c.getInputHandler());
        oh.writeGTF(data2, gtfFile);
        this.assertFilesMatch("test/output/testGTF.gtf", gtfFile);
        gtfFile = "test/working/shortTrainInterval13.gtf";
        List<? extends TrainingSequence<?>> data3 = ih.readTrainingData("test/input/interval13/data/shortTrain.interval13.txt");
        oh = new OutputHandlerGeneCallStats(c.getModel(), ih);
        oh.writeGTF(data3, gtfFile);
        this.assertFilesMatch("test/output/shortTrain.gtf", gtfFile);
    }
}

