/*
 * Decompiled with CFR 0.152.
 */
package calhoun.analysis.crf.test;

import calhoun.analysis.crf.Conrad;
import calhoun.analysis.crf.features.interval29.StateTransitionsInterval29;
import calhoun.analysis.crf.io.SequenceConverter;
import calhoun.analysis.crf.io.TrainingSequence;
import java.util.List;
import junit.framework.TestCase;

public class Interval29FeatureTest
extends TestCase {
    public void testStateTransitions() throws Exception {
        Conrad cr = new Conrad("test/input/interval29/config/ssbaselineCPD2Int29.xml");
        List<TrainingSequence<?>> data = cr.getInputHandler().readTrainingData("test/input/interval13/data/oneGeneTrain.interval13.txt");
        for (TrainingSequence<?> seq : data) {
            seq.setY(SequenceConverter.convertSeqFromInterval13ToInterval29(seq.getY()));
        }
        StateTransitionsInterval29 f = new StateTransitionsInterval29();
        f.train(0, cr.getModel(), (List<? extends TrainingSequence<? extends Character>>)data);
        Interval29FeatureTest.assertEquals((Object)Math.log(0.25), (Object)f.getEndProb());
        Interval29FeatureTest.assertEquals((Object)Math.log(0.75), (Object)f.getIntronProb());
    }
}

