/*
 * Decompiled with CFR 0.152.
 */
package calhoun.analysis.crf.test;

import calhoun.analysis.crf.AbstractFeatureManager;
import calhoun.analysis.crf.CacheStrategySpec;
import calhoun.analysis.crf.FeatureList;
import calhoun.analysis.crf.ModelManager;
import calhoun.analysis.crf.io.InputSequence;
import calhoun.util.Assert;
import calhoun.util.DenseBooleanMatrix2D;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class TestFeatureManager
extends AbstractFeatureManager
implements ModelManager {
    private static final long serialVersionUID = 5316261467715122688L;
    private static final Log log = LogFactory.getLog(TestFeatureManager.class);
    int type;
    boolean lengthModel;
    boolean lengthFeatures;
    boolean edgeLengthFeatures = false;

    public TestFeatureManager(int type, int length) {
        this.type = type;
        this.lengthModel = length > 0;
        this.lengthFeatures = length == 2;
    }

    public TestFeatureManager(int type) {
        this(type, 0);
    }

    @Override
    public int getNumStates() {
        return 2;
    }

    @Override
    public String getStateName(int state) {
        return "testState" + state;
    }

    @Override
    public String getFeatureName(int featureIndex) {
        return "testFeature" + featureIndex;
    }

    @Override
    public int getNumFeatures() {
        return this.type == 2 ? 2 : 1;
    }

    @Override
    public void train(int startingIndex, ModelManager modelInfo, List data) {
    }

    @Override
    public DenseBooleanMatrix2D getLegalTransitions() {
        if (this.lengthModel) {
            DenseBooleanMatrix2D trans = new DenseBooleanMatrix2D(2, 2);
            trans.setQuick(0, 1, true);
            trans.setQuick(1, 0, true);
            return trans;
        }
        return null;
    }

    @Override
    public int getStateIndex(String name) {
        Assert.a(false);
        return 0;
    }

    public void evaluateEdge(InputSequence seq, int pos, int prevState, int state, FeatureList result) {
        if (this.type == 1 || this.type >= 2) {
            result.addFeature(this.type == 2 ? 1 : 0, (double)((float)Math.log(prevState == state ? 0.6666666666666666 : 0.3333333333333333)) * (this.edgeLengthFeatures ? 0.5 : 1.0));
        }
    }

    public void evaluateNode(InputSequence seq, int pos, int state, FeatureList result) {
        if (this.type == 0 || this.type >= 2) {
            result.addFeature(0, (double)((float)Math.log(state == 0 ? 0.3333333432674408 : 0.6666666865348816)) * (this.lengthFeatures ? 0.5 : 1.0));
        }
    }

    public void evaluateEdgeLength(InputSequence seq, int pos, int featLength, int prevState, int state, FeatureList result) {
        if (this.edgeLengthFeatures && (this.type == 1 || this.type >= 2)) {
            double val = 0.5 * Math.log(prevState == state ? 0.6666666666666666 : 0.3333333333333333) + 0.5 * (double)(featLength - 1) * Math.log(0.6666666666666666);
            result.addFeature(this.type == 2 ? 1 : 0, (float)val);
        }
    }

    public void evaluateNodeLength(InputSequence seq, int pos, int featLength, int state, FeatureList result) {
        if (this.edgeLengthFeatures && (this.type == 1 || this.type >= 2) && featLength == pos + 1) {
            result.addFeature(this.type == 2 ? 1 : 0, (double)(0.5f * (float)(featLength - 1)) * Math.log(0.6666666666666666));
        }
        if (this.lengthFeatures && (this.type == 0 || this.type >= 2)) {
            double val = 0.5 * Math.log(state == 0 ? 0.3333333432674408 : 0.6666666865348816) * (double)featLength;
            result.addFeature(0, (float)val);
        }
    }

    public void buildFeatureCache(String directory, List sequence) {
    }

    @Override
    public CacheStrategySpec getCacheStrategy() {
        return new CacheStrategySpec(CacheStrategySpec.CacheStrategy.UNSPECIFIED);
    }
}

