/*
 * Decompiled with CFR 0.152.
 */
package calhoun.analysis.crf.test;

import calhoun.analysis.crf.AbstractFeatureManager;
import calhoun.analysis.crf.CacheStrategySpec;
import calhoun.analysis.crf.FeatureList;
import calhoun.analysis.crf.FeatureManager;
import calhoun.analysis.crf.FeatureManagerEdge;
import calhoun.analysis.crf.FeatureManagerNode;
import calhoun.analysis.crf.FeatureManagerNodeExplicitLength;
import calhoun.analysis.crf.ModelManager;
import calhoun.analysis.crf.io.InputSequence;
import calhoun.analysis.crf.io.TrainingSequence;
import java.util.List;

public class TestFeatures {

    public static class HalfExponentialLengthFeature
    extends TestFeature
    implements FeatureManagerEdge<Character> {
        private static final long serialVersionUID = 290546936098017942L;
        float[] vals = new float[]{0.8f, 0.2f, 0.2f, (float)Math.sqrt(0.8)};

        @Override
        public void evaluateEdge(InputSequence<? extends Character> seq, int pos, int prevState, int state, FeatureList result) {
            result.addFeature(this.startIx, Math.log(this.vals[prevState + 2 * state]));
        }

        @Override
        public CacheStrategySpec getCacheStrategy() {
            return new CacheStrategySpec(CacheStrategySpec.CacheStrategy.UNSPECIFIED);
        }
    }

    public static class ExponentialLengthFeature
    extends TestFeature
    implements FeatureManagerEdge<Character> {
        private static final long serialVersionUID = 290546936098017942L;
        float[] vals = new float[]{0.8f, 0.2f, 0.2f, 0.8f};

        @Override
        public void evaluateEdge(InputSequence<? extends Character> seq, int pos, int prevState, int state, FeatureList result) {
            result.addFeature(this.startIx, Math.log(this.vals[prevState + 2 * state]));
        }

        @Override
        public CacheStrategySpec getCacheStrategy() {
            return new CacheStrategySpec(CacheStrategySpec.CacheStrategy.UNSPECIFIED);
        }
    }

    public static class ExplicitHalfExponentialLengthFeature
    extends TestFeature
    implements FeatureManagerNodeExplicitLength<Character>,
    FeatureManagerEdge<Character> {
        private static final long serialVersionUID = 6050417482057409153L;
        float[] vals = new float[]{0.8f, 0.2f, 0.2f, (float)Math.sqrt(0.8)};

        @Override
        public void evaluateNodeLength(InputSequence<? extends Character> seq, int pos, int length, int state, FeatureList result) {
            if (state == 1) {
                float val = (float)((double)(length - 1) * Math.log(0.8) / 2.0);
                result.addFeature(this.startIx, val);
            }
        }

        @Override
        public void evaluateEdge(InputSequence<? extends Character> seq, int pos, int prevState, int state, FeatureList result) {
            result.addFeature(this.startIx, Math.log(this.vals[prevState + 2 * state]));
        }

        @Override
        public CacheStrategySpec getCacheStrategy() {
            return new CacheStrategySpec(CacheStrategySpec.CacheStrategy.UNSPECIFIED);
        }
    }

    public static class GaussianLengthFeature
    extends TestFeature
    implements FeatureManagerNodeExplicitLength<Character> {
        private static final long serialVersionUID = 6050417482057409153L;

        @Override
        public void evaluateNodeLength(InputSequence<? extends Character> seq, int pos, int length, int state, FeatureList result) {
            double val = 0.0;
            if (state == 1) {
                val = Math.pow(length - 6, 2.0);
                result.addFeature(this.startIx, val);
            }
        }

        @Override
        public CacheStrategySpec getCacheStrategy() {
            return new CacheStrategySpec(CacheStrategySpec.CacheStrategy.UNSPECIFIED);
        }
    }

    public static class EmissionFeature
    extends TestFeature
    implements FeatureManagerNode<Character> {
        private static final long serialVersionUID = 8039479168741225007L;

        @Override
        public void evaluateNode(InputSequence<? extends Character> seq, int pos, int state, FeatureList result) {
            boolean match;
            Character c = seq.getX(pos);
            boolean bl = match = state == 0;
            if (c.charValue() == 'G' || c.charValue() == 'C') {
                match = state == 1;
            }
            result.addFeature(this.startIx, match ? Math.log(0.8) : Math.log(0.2));
        }

        @Override
        public CacheStrategySpec getCacheStrategy() {
            return new CacheStrategySpec(CacheStrategySpec.CacheStrategy.UNSPECIFIED);
        }
    }

    public static abstract class TestFeature
    extends AbstractFeatureManager<Character>
    implements FeatureManager<Character> {
        int startIx;

        @Override
        public String getFeatureName(int featureIndex) {
            return this.getClass().getName();
        }

        @Override
        public int getNumFeatures() {
            return 1;
        }

        @Override
        public void train(int startingIndex, ModelManager modelInfo, List<? extends TrainingSequence<? extends Character>> data) {
            this.startIx = startingIndex;
        }
    }
}

