/*
 * Decompiled with CFR 0.152.
 */
package calhoun.util;

import calhoun.util.ErrorException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class Util {
    private Util() {
    }

    public static <T> void addAll(Collection<T> coll, Iterator<? extends T> iter) {
        while (iter.hasNext()) {
            coll.add(iter.next());
        }
    }

    public static void normalizeWeights(float[] weights) {
        int i;
        float total = 0.0f;
        for (i = 0; i < weights.length; ++i) {
            total += weights[i];
        }
        for (i = 0; i < weights.length; ++i) {
            weights[i] = weights[i] / total;
        }
    }

    public static int[] convertIntList(List<Integer> list) {
        int[] labelArray = new int[list.size()];
        for (int j = 0; j < labelArray.length; ++j) {
            labelArray[j] = list.get(j);
        }
        return labelArray;
    }

    public static float[] convertFloatList(List<Float> list) {
        float[] labelArray = new float[list.size()];
        for (int j = 0; j < labelArray.length; ++j) {
            labelArray[j] = list.get(j).floatValue();
        }
        return labelArray;
    }

    public static List<Double> convertDoubleArray(double[] list) {
        ArrayList<Double> labelArray = new ArrayList<Double>(list.length);
        for (int j = 0; j < list.length; ++j) {
            labelArray.add(list[j]);
        }
        return labelArray;
    }

    public static boolean safeEquals(Object x, Object y) {
        if (x == null) {
            return y == null;
        }
        return x.equals(y);
    }

    public static Object deepClone(Object o) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(o);
            oos.close();
            ByteArrayInputStream bios = new ByteArrayInputStream(baos.toByteArray());
            ObjectInputStream ois = new ObjectInputStream(bios);
            Object copy = ois.readObject();
            return copy;
        }
        catch (Exception ex) {
            throw new ErrorException("Could not copy object " + o.toString(), ex);
        }
    }
}

