/*
 * Decompiled with CFR 0.152.
 */
package calhoun.util;

import calhoun.util.XmlUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.Element;

public class XmlDiff {
    private static final Log log = LogFactory.getLog(XmlDiff.class);

    private XmlDiff() {
    }

    public static String compareFiles(String templateName, String docName) {
        log.debug((Object)("Comparing files: " + templateName + " and " + docName));
        Document template = XmlUtil.parseFile(templateName);
        Document doc = XmlUtil.parseFile(docName);
        List result = new ArrayList<String>();
        if (template.getRootElement().getName() != doc.getRootElement().getName()) {
            result.add("Root nodes don't match.  Expected: '" + template.getRootElement().getName() + "', Received: " + doc.getRootElement().getName());
        } else {
            result = XmlDiff.compareXmlElements(template.getRootElement(), doc.getRootElement());
        }
        if (result.size() == 0) {
            return null;
        }
        return "Files differ: " + docName + " doesn't match " + templateName + "\n" + StringUtils.join(result.iterator(), (char)'\n');
    }

    static List compareXmlElements(Element template, Element doc) {
        ArrayList<String> result = new ArrayList<String>();
        log.debug((Object)("Comparing elements: " + template.getUniquePath() + " and " + doc.getUniquePath()));
        HashSet attributes = new HashSet(doc.attributes());
        for (Attribute attribute : template.attributes()) {
            Attribute docAttribute = doc.attribute(attribute.getQName());
            if (docAttribute == null) {
                result.add(template.getUniquePath() + ": Expected: " + attribute.getQualifiedName() + "='" + attribute.getValue() + "', Received: No attribute");
                continue;
            }
            String comp = XmlDiff.compareValues(attribute.getValue(), docAttribute.getValue());
            if (comp != null) {
                result.add(attribute.getUniquePath() + ": " + comp);
            }
            attributes.remove(docAttribute);
        }
        for (Attribute attribute : attributes) {
            result.add(template.getUniquePath() + ": Expected: No Attribute, Received: " + attribute.getQualifiedName() + "='" + attribute.getValue() + "'");
        }
        if (template.isTextOnly()) {
            if (!doc.isTextOnly()) {
                result.add(template.getUniquePath() + ": Expected: '" + template.getText() + "', Received: Non-text content");
            } else {
                String comp = XmlDiff.compareValues(template.getText(), doc.getText());
                if (comp != null) {
                    result.add(template.getUniquePath() + ": " + comp);
                }
            }
        }
        HashSet<Element> matchedElements = new HashSet<Element>();
        for (Element child : template.elements()) {
            ArrayList docElements = new ArrayList(doc.elements(child.getQName()));
            docElements.removeAll(matchedElements);
            if (docElements.size() == 0) {
                result.add(template.getUniquePath() + ": Expected: <" + child.getQualifiedName() + ">, Received: No child element");
                continue;
            }
            int fewestProbs = 999999999;
            Iterator docIit = docElements.iterator();
            Element bestElement = null;
            List bestResults = null;
            while (docIit.hasNext()) {
                Element docElement = (Element)docIit.next();
                List childResult = XmlDiff.compareXmlElements(child, docElement);
                if (childResult.size() < fewestProbs) {
                    fewestProbs = childResult.size();
                    bestElement = docElement;
                    bestResults = childResult;
                }
                if (fewestProbs != 0) continue;
                break;
            }
            matchedElements.add(bestElement);
            result.addAll(bestResults);
            if (docElements.size() <= 1) continue;
            log.debug((Object)("Matched: " + child.getUniquePath() + " with " + bestElement.getUniquePath()));
        }
        HashSet unmatchedElements = new HashSet(doc.elements());
        unmatchedElements.removeAll(matchedElements);
        for (Element element : unmatchedElements) {
            result.add(template.getUniquePath() + ": Expected: No Child Element, Received: <" + element.getQualifiedName() + ">");
        }
        return result;
    }

    static String compareValues(String templateValue, String docValue) {
        String regex;
        if (templateValue.equals("*")) {
            return null;
        }
        if (templateValue.startsWith("REGEX:") ? !Pattern.compile(regex = templateValue.substring("REGEX:".length())).matcher(docValue).matches() : !templateValue.equals(docValue)) {
            return "Expected: '" + templateValue + "', Received: '" + docValue + "'";
        }
        return null;
    }
}

