/*
 * Decompiled with CFR 0.152.
 */
package flanagan.math.test;

import flanagan.math.Minimisation;
import flanagan.math.MinimisationFunction;
import junit.framework.TestCase;

public class NelderMeadTest
extends TestCase {
    public void testNelderMead() throws Exception {
        Minimisation m = new Minimisation();
        m.nelderMead(new Quadratic(), new double[]{1.0});
        NelderMeadTest.assertEquals((double)4.0, (double)m.getMinimum(), (double)1.0E-4);
        NelderMeadTest.assertEquals((double)3.0, (double)m.getParamValues()[0], (double)1.0E-4);
        m.nelderMead(new MultivariateQuadratic(), new double[]{1.0, 1.0});
        NelderMeadTest.assertEquals((double)5.0, (double)m.getMinimum(), (double)1.0E-4);
        NelderMeadTest.assertEquals((double)3.0, (double)m.getParamValues()[0], (double)1.0E-4);
        NelderMeadTest.assertEquals((double)4.0, (double)m.getParamValues()[1], (double)1.0E-4);
    }

    class MultivariateQuadratic
    implements MinimisationFunction {
        int a = 2;
        int b = 3;
        int c = 4;
        int d = 5;

        MultivariateQuadratic() {
        }

        @Override
        public double function(double[] param) {
            return (double)this.a * Math.pow(param[0] - (double)this.b, 2.0) + (double)this.a * Math.pow(param[1] - (double)this.c, 2.0) + (double)this.d;
        }
    }

    class Quadratic
    implements MinimisationFunction {
        int a = 2;
        int b = 3;
        int c = 4;

        Quadratic() {
        }

        @Override
        public double function(double[] param) {
            return (double)this.a * Math.pow(param[0] - (double)this.b, 2.0) + (double)this.c;
        }
    }
}

