/*
 * Decompiled with CFR 0.152.
 */
package fmph.features.mitochondrion1;

import calhoun.analysis.crf.AbstractFeatureManager;
import calhoun.analysis.crf.CacheStrategySpec;
import calhoun.analysis.crf.FeatureList;
import calhoun.analysis.crf.FeatureManagerEdge;
import calhoun.analysis.crf.ModelManager;
import calhoun.analysis.crf.features.supporting.PWMLookup;
import calhoun.analysis.crf.io.InputSequence;
import calhoun.analysis.crf.io.TrainingSequence;
import calhoun.util.Assert;
import fmph.features.mitochondrion1.Mitochondrion1Model;
import fmph.features.mitochondrion1.Mitochondrion1Tools;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PWMMitochondrion1
extends AbstractFeatureManager<Character>
implements FeatureManagerEdge<Character> {
    private static final long serialVersionUID = -7659288739348604129L;
    private static final Log log = LogFactory.getLog(PWMMitochondrion1.class);
    boolean debug = log.isDebugEnabled();
    boolean multipleFeatures = false;
    int startIx;
    ModelManager model;
    PWMLookup start;
    PWMLookup stop;
    PWMLookup[] donor;
    PWMLookup[] acceptor;
    double pseudoCounts;

    @Override
    public int getNumFeatures() {
        return this.multipleFeatures ? 8 : 1;
    }

    @Override
    public String getFeatureName(int featureIndex) {
        if (this.multipleFeatures) {
            String[] vals = new String[]{"Start", "Stop", "Donor 0", "Donor 1", "Donor 2", "Acceptor 0", "Acceptor 1", "Acceptor 2"};
            String feature = vals[featureIndex - this.startIx];
            return feature + " PWM";
        }
        Assert.a(featureIndex == this.startIx);
        return "PwmFeatureInterval13";
    }

    @Override
    public void train(int startingIndex, ModelManager modelInfo, List<? extends TrainingSequence<? extends Character>> data) {
        this.startIx = startingIndex;
        this.model = modelInfo;
        Mitochondrion1Tools.verify(modelInfo);
        this.pseudoCounts = 1.0;
        this.donor = new PWMLookup[3];
        this.acceptor = new PWMLookup[3];
        for (int j = 0; j < 3; ++j) {
            this.donor[j] = new PWMLookup(Mitochondrion1Model.getPadExon3prime(), Mitochondrion1Model.getPadIntron5prime(), this.pseudoCounts);
            this.acceptor[j] = new PWMLookup(Mitochondrion1Model.getPadIntron3prime(), Mitochondrion1Model.getPadExon5prime(), this.pseudoCounts);
        }
        this.start = new PWMLookup(Mitochondrion1Model.getPadIntergenic(), Mitochondrion1Model.getPadExon5prime(), this.pseudoCounts);
        this.stop = new PWMLookup(Mitochondrion1Model.getPadExon3prime(), Mitochondrion1Model.getPadIntergenic(), this.pseudoCounts);
        for (TrainingSequence<? extends Character> trainingSequence : data) {
            block14: for (int pos = 1; pos < trainingSequence.length(); ++pos) {
                int state = trainingSequence.getY(pos);
                int prevState = trainingSequence.getY(pos - 1);
                switch (Mitochondrion1Tools.edgeConstraints[prevState * Mitochondrion1Tools.numStates + state]) {
                    case NONE: 
                    case PCODE: 
                    case MCODE: {
                        continue block14;
                    }
                    case NEVER: {
                        Assert.a(false, "pos = " + pos + " prevState = " + modelInfo.getStateName(prevState) + "   State = " + modelInfo.getStateName(state));
                        continue block14;
                    }
                    case PSTART: {
                        this.start.increment(trainingSequence, pos, true);
                        continue block14;
                    }
                    case PDON: {
                        int iind = Mitochondrion1Tools.check012(state - 4);
                        this.donor[iind].increment(trainingSequence, pos, true);
                        continue block14;
                    }
                    case PACC: {
                        int iind = Mitochondrion1Tools.check012(prevState - 4);
                        this.acceptor[iind].increment(trainingSequence, pos, true);
                        continue block14;
                    }
                    case PSTOP: {
                        this.stop.increment(trainingSequence, pos, true);
                        continue block14;
                    }
                    case MSTART: {
                        this.start.increment(trainingSequence, pos, false);
                        continue block14;
                    }
                    case MDON: {
                        int iind = Mitochondrion1Tools.check012(prevState - 10);
                        this.donor[iind].increment(trainingSequence, pos, false);
                        continue block14;
                    }
                    case MACC: {
                        int iind = Mitochondrion1Tools.check012(state - 10);
                        this.acceptor[iind].increment(trainingSequence, pos, false);
                        continue block14;
                    }
                    case MSTOP: {
                        this.stop.increment(trainingSequence, pos, false);
                        continue block14;
                    }
                    default: {
                        Assert.a(false);
                    }
                }
            }
        }
        for (int j = 0; j < 3; ++j) {
            this.donor[j].completeCounts();
            this.acceptor[j].completeCounts();
        }
        this.start.completeCounts();
        this.stop.completeCounts();
    }

    @Override
    public void evaluateEdge(InputSequence<? extends Character> seq, int pos, int previousState, int state, FeatureList result) {
        double val = 0.0;
        int featureIndex = Integer.MIN_VALUE;
        switch (Mitochondrion1Tools.edgeConstraints[previousState * Mitochondrion1Tools.numStates + state]) {
            case NONE: 
            case PCODE: 
            case MCODE: {
                break;
            }
            case NEVER: {
                Assert.a(false);
                break;
            }
            case PSTART: {
                featureIndex = 0;
                val = this.start.lookup(seq, pos, true);
                break;
            }
            case PDON: {
                int iind = Mitochondrion1Tools.check012(state - 4);
                featureIndex = 2 + iind;
                val = this.donor[iind].lookup(seq, pos, true);
                break;
            }
            case PACC: {
                int iind = Mitochondrion1Tools.check012(previousState - 4);
                featureIndex = 5 + iind;
                val = this.acceptor[iind].lookup(seq, pos, true);
                break;
            }
            case PSTOP: {
                featureIndex = 1;
                val = this.stop.lookup(seq, pos, true);
                break;
            }
            case MSTART: {
                featureIndex = 0;
                val = this.start.lookup(seq, pos, false);
                break;
            }
            case MDON: {
                int iind = Mitochondrion1Tools.check012(previousState - 10);
                featureIndex = 2 + iind;
                val = this.donor[iind].lookup(seq, pos, false);
                break;
            }
            case MACC: {
                int iind = Mitochondrion1Tools.check012(state - 10);
                featureIndex = 5 + iind;
                val = this.acceptor[iind].lookup(seq, pos, false);
                break;
            }
            case MSTOP: {
                featureIndex = 1;
                val = this.stop.lookup(seq, pos, false);
                break;
            }
            default: {
                Assert.a(false);
            }
        }
        Assert.a(val <= 0.0);
        result.addFeature(this.startIx + (this.multipleFeatures ? featureIndex : 0), val);
    }

    @Override
    public CacheStrategySpec getCacheStrategy() {
        return new CacheStrategySpec(CacheStrategySpec.CacheStrategy.UNSPECIFIED);
    }

    public boolean isMultipleFeatures() {
        return this.multipleFeatures;
    }

    public void setMultipleFeatures(boolean multipleFeatures) {
        this.multipleFeatures = multipleFeatures;
    }
}

