/*
 * Decompiled with CFR 0.152.
 */
package fmph.features.mitochondrion1;

import calhoun.analysis.crf.AbstractFeatureManager;
import calhoun.analysis.crf.CacheStrategySpec;
import calhoun.analysis.crf.FeatureList;
import calhoun.analysis.crf.FeatureManagerNode;
import calhoun.analysis.crf.ModelManager;
import calhoun.analysis.crf.features.supporting.phylogenetic.EvolutionaryModel;
import calhoun.analysis.crf.features.supporting.phylogenetic.Kimura80Model;
import calhoun.analysis.crf.features.supporting.phylogenetic.PhylogeneticTreeFelsensteinOrder;
import calhoun.analysis.crf.io.InputSequence;
import calhoun.analysis.crf.io.MultipleAlignmentInputSequence;
import calhoun.analysis.crf.io.TrainingSequence;
import calhoun.seq.KmerHasher;
import calhoun.util.Assert;
import flanagan.math.Minimisation;
import flanagan.math.MinimisationFunction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PhylogeneticLogprobMitochondrion1
extends AbstractFeatureManager<MultipleAlignmentInputSequence.MultipleAlignmentColumn>
implements FeatureManagerNode<MultipleAlignmentInputSequence.MultipleAlignmentColumn> {
    private static final long serialVersionUID = -7659288739348604129L;
    private static final Log log = LogFactory.getLog(PhylogeneticLogprobMitochondrion1.class);
    int startIx;
    ModelManager model;
    boolean multipleFeatures = false;
    EvolutionaryModel emodelIntergenic;
    EvolutionaryModel emodelIntronic;
    ArrayList<EvolutionaryModel> emodelExonic;
    static KmerHasher hforward = new KmerHasher(KmerHasher.ACGTother, 1);
    static KmerHasher hbackward = new KmerHasher(KmerHasher.ACGTotherRC, 1);

    @Override
    public int getNumFeatures() {
        return this.multipleFeatures ? 5 : 1;
    }

    @Override
    public String getFeatureName(int featureIndex) {
        if (this.multipleFeatures) {
            String[] vals = new String[]{"Intergenic", "Exon pos.", "Intron pos.", "Exon neg.", "Intron neg."};
            int feat = featureIndex - this.startIx;
            String table = vals[feat];
            return table + " phylogeny";
        }
        return "PhylogeneticLogProbInterval13";
    }

    @Override
    public void evaluateNode(InputSequence<? extends MultipleAlignmentInputSequence.MultipleAlignmentColumn> seq, int pos, int state, FeatureList result) {
        Assert.a(state < this.model.getNumStates());
        MultipleAlignmentInputSequence.MultipleAlignmentColumn col = seq.getX(pos);
        double val = 0.0;
        int featureOffset = Integer.MIN_VALUE;
        switch (state) {
            case 0: {
                val = this.emodelIntergenic.logprob(col, true);
                featureOffset = 0;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                int ephase = ((pos - state + 1) % 3 + 3) % 3;
                val = this.emodelExonic.get(ephase).logprob(col, true);
                featureOffset = 1;
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                val = this.emodelIntronic.logprob(col, true);
                featureOffset = 2;
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                int ephase = ((-pos + state + 1) % 3 + 3) % 3;
                val = this.emodelExonic.get(ephase).logprobRC(col, true);
                featureOffset = 3;
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                val = this.emodelIntronic.logprobRC(col, true);
                featureOffset = 4;
                break;
            }
            default: {
                Assert.a(false);
            }
        }
        result.addFeature(this.startIx + (this.multipleFeatures ? featureOffset : 0), val);
    }

    @Override
    public void train(int startingIndex, ModelManager modelInfo, List<? extends TrainingSequence<? extends MultipleAlignmentInputSequence.MultipleAlignmentColumn>> data) {
        int y;
        int pos;
        boolean[] fb;
        boolean[] ff;
        int len;
        TrainingSequence<? extends MultipleAlignmentInputSequence.MultipleAlignmentColumn> aln;
        int seqNum;
        this.startIx = startingIndex;
        this.model = modelInfo;
        PhylogeneticTreeFelsensteinOrder felsOrder = data.get(0).getX(0).getMultipleAlignment().getFelsensteinOrder();
        ArrayList<boolean[]> flagsForward = new ArrayList<boolean[]>();
        ArrayList<boolean[]> flagsBackward = new ArrayList<boolean[]>();
        for (seqNum = 0; seqNum < data.size(); ++seqNum) {
            aln = data.get(seqNum);
            len = aln.length();
            flagsForward.add(new boolean[len]);
            flagsBackward.add(new boolean[len]);
        }
        log.debug((Object)"Training model for intergenic regions...");
        for (seqNum = 0; seqNum < data.size(); ++seqNum) {
            aln = data.get(seqNum);
            len = aln.length();
            ff = flagsForward.get(seqNum);
            Assert.a(ff.length == len);
            fb = flagsBackward.get(seqNum);
            Assert.a(fb.length == len);
            for (pos = 0; pos < len; ++pos) {
                y = aln.getY(pos);
                if (y == 0) {
                    ff[pos] = true;
                    fb[pos] = true;
                    continue;
                }
                ff[pos] = false;
                fb[pos] = false;
            }
        }
        this.emodelIntergenic = this.trainEvolutionaryModel(felsOrder, data, flagsForward, flagsBackward);
        log.debug((Object)"Evolutionary model for intergenic regions:");
        this.emodelIntergenic.summarize();
        log.debug((Object)"Training model for intronic regions...");
        for (seqNum = 0; seqNum < data.size(); ++seqNum) {
            aln = data.get(seqNum);
            len = aln.length();
            ff = flagsForward.get(seqNum);
            Assert.a(ff.length == len);
            fb = flagsBackward.get(seqNum);
            Assert.a(fb.length == len);
            for (pos = 0; pos < len; ++pos) {
                y = aln.getY(pos);
                ff[pos] = y == 4 || y == 5 || y == 6;
                fb[pos] = y == 10 || y == 11 || y == 12;
            }
        }
        this.emodelIntronic = this.trainEvolutionaryModel(felsOrder, data, flagsForward, flagsBackward);
        log.debug((Object)"Evolutionary model for intronic regions:");
        this.emodelIntronic.summarize();
        this.emodelExonic = new ArrayList();
        for (int phase = 0; phase < 3; ++phase) {
            log.debug((Object)"Training model for exonic regions...");
            for (int seqNum2 = 0; seqNum2 < data.size(); ++seqNum2) {
                TrainingSequence<? extends MultipleAlignmentInputSequence.MultipleAlignmentColumn> aln2 = data.get(seqNum2);
                int len2 = aln2.length();
                boolean[] ff2 = flagsForward.get(seqNum2);
                Assert.a(ff2.length == len2);
                boolean[] fb2 = flagsBackward.get(seqNum2);
                Assert.a(fb2.length == len2);
                for (int pos2 = 0; pos2 < len2; ++pos2) {
                    int y2 = aln2.getY(pos2);
                    int pstate = ((pos2 - phase) % 3 + 3) % 3 + 1;
                    int mstate = ((phase + pos2 - 2) % 3 + 3) % 3 + 7;
                    ff2[pos2] = y2 == pstate;
                    fb2[pos2] = y2 == mstate;
                }
            }
            this.emodelExonic.add(this.trainEvolutionaryModel(felsOrder, data, flagsForward, flagsBackward));
            log.debug((Object)"Evolutionary model for exonic regions:");
            this.emodelExonic.get(phase).summarize();
        }
        log.debug((Object)"Just trained all evolutionary models");
    }

    private EvolutionaryModel trainEvolutionaryModel(final PhylogeneticTreeFelsensteinOrder felsOrder, final List<? extends TrainingSequence<? extends MultipleAlignmentInputSequence.MultipleAlignmentColumn>> data, final ArrayList<boolean[]> flagsForward, final ArrayList<boolean[]> flagsBackward) {
        Assert.a(flagsForward.size() == data.size());
        Assert.a(flagsBackward.size() == data.size());
        final double[] pi = new double[]{1.0, 1.0, 1.0, 1.0};
        for (int seqNum = 0; seqNum < data.size(); ++seqNum) {
            TrainingSequence<? extends MultipleAlignmentInputSequence.MultipleAlignmentColumn> aln = data.get(seqNum);
            int len = aln.length();
            boolean[] ff = flagsForward.get(seqNum);
            Assert.a(ff.length == len);
            boolean[] fb = flagsBackward.get(seqNum);
            Assert.a(fb.length == len);
            for (int ix = 0; ix < len; ++ix) {
                int x;
                if (ff[ix] && (x = hforward.hash(aln.getX(ix).nucleotide(0))) < 4) {
                    int n = x;
                    pi[n] = pi[n] + 1.0;
                }
                if (!fb[ix] || (x = hbackward.hash(aln.getX(ix).nucleotide(0))) >= 4) continue;
                int n = x;
                pi[n] = pi[n] + 1.0;
            }
        }
        double total = pi[0] + pi[1] + pi[2] + pi[3];
        pi[0] = pi[0] / total;
        pi[1] = pi[1] / total;
        pi[2] = pi[2] / total;
        pi[3] = pi[3] / total;
        MinimisationFunction mFunc = new MinimisationFunction(){

            @Override
            public double function(double[] d) {
                double[] ed = new double[]{Math.exp(d[0]), Math.exp(d[1])};
                Kimura80Model R = new Kimura80Model(ed);
                EvolutionaryModel M = new EvolutionaryModel(felsOrder, pi, R);
                double ret = 0.0;
                for (int seqNum = 0; seqNum < data.size(); ++seqNum) {
                    TrainingSequence aln = (TrainingSequence)data.get(seqNum);
                    int len = aln.length();
                    boolean[] ff = (boolean[])flagsForward.get(seqNum);
                    Assert.a(ff.length == len);
                    boolean[] fb = (boolean[])flagsBackward.get(seqNum);
                    Assert.a(fb.length == len);
                    for (int ix = 0; ix < len; ++ix) {
                        if (ff[ix]) {
                            ret += M.logprob((MultipleAlignmentInputSequence.MultipleAlignmentColumn)aln.getX(ix), true);
                        }
                        if (!fb[ix]) continue;
                        ret += M.logprobRC((MultipleAlignmentInputSequence.MultipleAlignmentColumn)aln.getX(ix), true);
                    }
                }
                return -ret;
            }
        };
        int maxIter = 6000;
        int nParm = 2;
        Minimisation m = new Minimisation();
        m.setNmax(maxIter);
        double[] starts = new double[2];
        Arrays.fill(starts, 0.1);
        double[] steps = new double[2];
        Arrays.fill(steps, 0.1);
        m.nelderMead(mFunc, starts, steps);
        if (!m.getConvStatus()) {
            log.warn((Object)"WARNING - Nelder-Mead routine says convergence was not reached");
        }
        double[] results = m.getParamValues();
        double[] eresults = new double[]{Math.exp(results[0]), Math.exp(results[1])};
        return new EvolutionaryModel(felsOrder, pi, new Kimura80Model(eresults));
    }

    @Override
    public CacheStrategySpec getCacheStrategy() {
        return new CacheStrategySpec(CacheStrategySpec.CacheStrategy.DENSE);
    }

    public boolean isMultipleFeatures() {
        return this.multipleFeatures;
    }

    public void setMultipleFeatures(boolean multipleFeatures) {
        this.multipleFeatures = multipleFeatures;
    }
}

