/*
 * Decompiled with CFR 0.152.
 */
package fmph.features.util;

import calhoun.analysis.crf.Conrad;
import calhoun.analysis.crf.features.supporting.phylogenetic.EvolutionaryModel;
import calhoun.analysis.crf.features.supporting.phylogenetic.Kimura80Model;
import calhoun.analysis.crf.features.supporting.phylogenetic.PhylogeneticTreeFelsensteinOrder;
import calhoun.analysis.crf.io.InputSequence;
import calhoun.analysis.crf.io.MultipleAlignmentInputSequence;
import calhoun.analysis.crf.io.NameInputSequence;
import calhoun.analysis.crf.io.TrainingSequence;
import calhoun.util.Assert;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;

public class PhyloViewer {
    EvolutionaryModel emodelIntergenic;
    EvolutionaryModel emodelIntronic;
    ArrayList<EvolutionaryModel> emodelExonic;
    String nameComponent;
    String multipleAlnComponent;
    String intergenicOutputFile;
    String intronOutputFile;
    String exonOutputFile;

    public static void main(String[] args) throws Exception {
        new PhyloViewer(args);
    }

    public PhyloViewer(String[] args) throws IOException {
        this.nameComponent = args[2];
        this.multipleAlnComponent = args[3];
        this.intergenicOutputFile = args[4];
        this.intronOutputFile = args[5];
        this.exonOutputFile = args[6];
        Conrad crf = new Conrad(args[0]);
        List<TrainingSequence<?>> t = crf.getInputHandler().readTrainingData(args[1], false);
        PhylogeneticTreeFelsensteinOrder felsOrder = ((MultipleAlignmentInputSequence.MultipleAlignmentColumn)t.get(0).getComponent(args[3]).getX(0)).getMultipleAlignment().getFelsensteinOrder();
        this.emodelIntergenic = new EvolutionaryModel(felsOrder, new double[]{0.44448760556490713, 0.05551239443509287, 0.05551239443509287, 0.44448760556490713}, new Kimura80Model(new double[]{0.23740500177751464, 0.6536810457617929}));
        this.emodelIntronic = new EvolutionaryModel(felsOrder, new double[]{0.43914528597477975, 0.08378919793512597, 0.1197832395921617, 0.35728227649793254}, new Kimura80Model(new double[]{0.3394214824142834, 0.5146789433220592}));
        this.emodelExonic = new ArrayList();
        this.emodelExonic.add(new EvolutionaryModel(felsOrder, new double[]{0.337173765122421, 0.09340437555501736, 0.2211996447888916, 0.3482222145336701}, new Kimura80Model(new double[]{0.29820919354158326, 0.20188192420999146})));
        this.emodelExonic.add(new EvolutionaryModel(felsOrder, new double[]{0.24048632499336725, 0.19082719082719082, 0.12942519984773507, 0.43926128433170686}, new Kimura80Model(new double[]{0.22162973326046825, 0.1656976351280791})));
        this.emodelExonic.add(new EvolutionaryModel(felsOrder, new double[]{0.5036354823073195, 0.05671352399418323, 0.04398356531172818, 0.39566742838676916}, new Kimura80Model(new double[]{0.25051188519131423, 0.40170737974641324})));
        this.printValues(t, args);
    }

    private void printValues(List<? extends TrainingSequence<?>> t, String[] args) throws FileNotFoundException {
        PrintWriter pwInter = new PrintWriter(new FileOutputStream(this.intergenicOutputFile));
        PrintWriter pwIntron = new PrintWriter(new FileOutputStream(this.intronOutputFile));
        PrintWriter pwExon = new PrintWriter(new FileOutputStream(this.exonOutputFile));
        for (TrainingSequence<?> seq : t) {
            String name = ((NameInputSequence)seq.getInputSequence().getComponent(this.nameComponent)).getName();
            pwInter.println(">" + name);
            pwIntron.println(">" + name);
            pwExon.println(">" + name);
            InputSequence<?> aligSeq = seq.getComponent(this.multipleAlnComponent);
            block8: for (int pos = 0; pos < aligSeq.length(); ++pos) {
                MultipleAlignmentInputSequence.MultipleAlignmentColumn col = (MultipleAlignmentInputSequence.MultipleAlignmentColumn)aligSeq.getX(pos);
                int state = seq.getY(pos);
                int featureOffset = Integer.MIN_VALUE;
                switch (state) {
                    case 0: {
                        pwInter.println(this.emodelIntergenic.logprob(col, true));
                        pwIntron.println(this.emodelIntronic.logprob(col, true));
                        pwExon.println(this.emodelExonic.get(1).logprob(col, true));
                        continue block8;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        int ephase = ((pos - state + 1) % 3 + 3) % 3;
                        pwInter.println(this.emodelIntergenic.logprob(col, true));
                        pwIntron.println(this.emodelIntronic.logprob(col, true));
                        pwExon.println(this.emodelExonic.get(ephase).logprob(col, true));
                        continue block8;
                    }
                    case 4: 
                    case 5: 
                    case 6: {
                        pwInter.println(this.emodelIntergenic.logprob(col, true));
                        pwIntron.println(this.emodelIntronic.logprob(col, true));
                        pwExon.println(this.emodelExonic.get(1).logprob(col, true));
                        continue block8;
                    }
                    case 7: 
                    case 8: 
                    case 9: {
                        int ephase = ((-pos + state + 1) % 3 + 3) % 3;
                        pwInter.println(this.emodelIntergenic.logprob(col, true));
                        pwIntron.println(this.emodelIntronic.logprobRC(col, true));
                        pwExon.println(this.emodelExonic.get(ephase).logprobRC(col, true));
                        continue block8;
                    }
                    case 10: 
                    case 11: 
                    case 12: {
                        pwInter.println(this.emodelIntergenic.logprob(col, true));
                        pwIntron.println(this.emodelIntronic.logprobRC(col, true));
                        pwExon.println(this.emodelExonic.get(1).logprobRC(col, true));
                        continue block8;
                    }
                    default: {
                        Assert.a(false);
                    }
                }
            }
        }
        pwInter.close();
        pwIntron.close();
        pwExon.close();
    }
}

