/*
 * Decompiled with CFR 0.152.
 */
package mlproject.io;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import mlproject.hmm.StateModel;
import mlproject.io.InputReader;
import mlproject.io.InputSequence;
import mlproject.io.TrainingSequence;
import mlproject.util.Util;

public class GTFStateInputReaderEvidence137 {
    private HashMap<String, ArrayList<GTFElement>> cdsMap = new HashMap();
    private InputReader inputReader;
    private StateModel stateModel;
    private int[] exonerateCodingStats = new int[4];
    private int[] exonerateIntronStats = new int[4];
    private int[] weaselStats = new int[4];
    private int[] exonerateVsWeaselStats = new int[3];
    private int plusCount;
    private int minusCount;
    private int totalIntronLength;
    private int intronCount;
    private int totalExonLength;
    private int exonCount;
    private int exonerateAcceptorConsensuses;
    private int exonerateDonorConsensuses;
    private int weaselAcceptorConsensuses;
    private int weaselDonorConsensuses;

    public GTFStateInputReaderEvidence137(InputReader inputReader, String gtfFile, StateModel stateModel) throws FileNotFoundException, IOException {
        this.inputReader = inputReader;
        this.stateModel = stateModel;
        this.parseGTF(gtfFile);
    }

    public TrainingSequence readNextTrainingSequence() throws IOException {
        InputSequence in = this.inputReader.readNextSequence();
        if (in == null) {
            return null;
        }
        this.incrementStats(in);
        int[] states = this.readStates(in.getComponent(0));
        TrainingSequence result = new TrainingSequence(in, states);
        if (states == null) {
            result.setValid(false);
        } else {
            int i = 1;
            while (i < states.length) {
                if (!this.stateModel.getTransitionMatrix()[states[i - 1]][states[i]]) {
                    result.setValid(false);
                    System.out.println("Invalid sequence:" + in.getName() + " transition:" + states[i - 1] + "-" + states[i]);
                } else {
                    result.setValid(true);
                }
                ++i;
            }
        }
        return result;
    }

    private void parseGTF(String gtfFile) throws FileNotFoundException, IOException {
        String line;
        BufferedReader br = new BufferedReader(new FileReader(gtfFile));
        while ((line = br.readLine()) != null) {
            String[] fields;
            if (line.equals("") || !(fields = line.split("\t"))[2].equals("CDS")) continue;
            if (this.cdsMap.get(fields[0]) == null) {
                this.cdsMap.put(fields[0], new ArrayList());
            }
            GTFElement el = new GTFElement(null);
            el.gene = fields[0];
            el.start = Integer.parseInt(fields[3]);
            el.end = Integer.parseInt(fields[4]);
            el.strand = fields[6];
            this.cdsMap.get(fields[0]).add(el);
        }
        br.close();
        for (ArrayList<GTFElement> list : this.cdsMap.values()) {
            Collections.sort(list);
        }
    }

    public int[] readStates(InputSequence<Integer> fasta) throws IOException {
        int A = 0;
        int C = 1;
        int G = 2;
        int T = 3;
        ArrayList<GTFElement> list = this.cdsMap.get(fasta.getName());
        if (list == null) {
            throw new RuntimeException("Missing gtf:" + fasta.getName());
        }
        int[] states = new int[fasta.length()];
        int exonCount = 0;
        String strand = list.get((int)0).strand;
        int i = 0;
        while (i < list.size()) {
            if (i > 0) {
                int length = list.get((int)i).start - list.get((int)(i - 1)).end - 1;
                if (length < 14) {
                    System.out.println("Invalid sequence:" + fasta.getName() + " intron length:" + length);
                    return null;
                }
                if (strand.equals("+")) {
                    int phase = exonCount % 3;
                    int baseState = -1;
                    baseState = phase == 0 ? 12 : (phase == 1 ? (fasta.getX(list.get((int)(i - 1)).end - 1) == T ? 28 : 44) : (fasta.getX(list.get((int)(i - 1)).end - 2) == T ? (fasta.getX(list.get((int)(i - 1)).end - 1) == A ? 60 : 76) : 92));
                    int pos = 0;
                    while (pos < 6) {
                        states[list.get((int)(i - 1)).end + pos] = baseState + pos;
                        ++pos;
                    }
                    int pos2 = 0;
                    while (pos2 < 9) {
                        states[list.get((int)i).start - 10 + pos2] = baseState + 7 + pos2;
                        ++pos2;
                    }
                    Arrays.fill(states, list.get((int)(i - 1)).end + 6, list.get((int)i).start - 10, baseState + 6);
                } else {
                    int phase = (3 - exonCount % 3) % 3;
                    int baseState = -1;
                    baseState = phase == 0 ? 122 : (phase == 1 ? (fasta.getX(list.get((int)(i - 1)).end - 2) == C || fasta.getX(list.get((int)(i - 1)).end - 2) == T ? (fasta.getX(list.get((int)(i - 1)).end - 1) == T ? 138 : 154) : 170) : (fasta.getX(list.get((int)(i - 1)).end - 2) == C || fasta.getX(list.get((int)(i - 1)).end - 2) == T ? 186 : 202));
                    int pos = 0;
                    while (pos < 9) {
                        states[list.get((int)(i - 1)).end + pos] = baseState + pos;
                        ++pos;
                    }
                    int pos3 = 0;
                    while (pos3 < 6) {
                        states[list.get((int)i).start - 7 + pos3] = baseState + 10 + pos3;
                        ++pos3;
                    }
                    Arrays.fill(states, list.get((int)(i - 1)).end + 9, list.get((int)i).start - 7, baseState + 9);
                }
            }
            if (i == 0 && strand.equals("+")) {
                Arrays.fill(states, list.get((int)i).start + 2, list.get((int)i).end, 1);
            } else if (i == list.size() - 1 && strand.equals("-")) {
                Arrays.fill(states, list.get((int)i).start - 1, list.get((int)i).end - 3, 1);
            } else {
                Arrays.fill(states, list.get((int)i).start - 1, list.get((int)i).end, 1);
            }
            exonCount += list.get((int)i).end - list.get((int)i).start + 1;
            ++i;
        }
        int[] codon = new int[3];
        int[] positions = new int[3];
        int codonPosition = 0;
        int i2 = 0;
        while (i2 < states.length) {
            if (states[i2] == 1) {
                codon[codonPosition] = fasta.getX(i2);
                positions[codonPosition] = i2;
                if ((codonPosition = (codonPosition + 1) % 3) == 0) {
                    if (strand.equals("+")) {
                        if (codon[0] == T) {
                            if (codon[1] == A) {
                                if (codon[2] == G || codon[2] == A) {
                                    System.out.println("Invalid sequence:" + fasta.getName() + " codon TAA/TAG in CDS pos:" + i2);
                                    return null;
                                }
                                states[positions[0]] = 4;
                                states[positions[1]] = 6;
                                states[positions[2]] = 9;
                            } else {
                                states[positions[0]] = 4;
                                states[positions[1]] = 7;
                                states[positions[2]] = 10;
                            }
                        } else {
                            states[positions[0]] = 5;
                            states[positions[1]] = 8;
                            states[positions[2]] = 11;
                        }
                    } else if (codon[0] == C || codon[0] == T) {
                        if (codon[1] == T) {
                            if (codon[2] == A) {
                                System.out.println("Invalid sequence:" + fasta.getName() + " codon TAA/TAG in CDS pos:" + i2);
                                return null;
                            }
                            states[positions[0]] = 114;
                            states[positions[1]] = 116;
                            states[positions[2]] = 119;
                        } else {
                            states[positions[0]] = 114;
                            states[positions[1]] = 117;
                            states[positions[2]] = 120;
                        }
                    } else {
                        states[positions[0]] = 115;
                        states[positions[1]] = 118;
                        states[positions[2]] = 121;
                    }
                }
            }
            ++i2;
        }
        int i3 = 0;
        while (i3 < list.size()) {
            GTFElement el = list.get(i3);
            if (i3 == 0) {
                if (el.strand.equals("+")) {
                    if (fasta.getX(el.start - 1) != A || fasta.getX(el.start) != T || fasta.getX(el.start + 1) != G && fasta.getX(el.start + 1) != A) {
                        System.out.println("Invalid sequence:" + fasta.getName() + " invalid plus start codon ATG/A");
                        return null;
                    }
                    states[el.start - 1] = 1;
                    states[el.start] = 2;
                    states[el.start + 1] = 3;
                } else {
                    if (fasta.getX(el.start - 4) != T && fasta.getX(el.start - 4) != C || fasta.getX(el.start - 3) != T || fasta.getX(el.start - 2) != A) {
                        System.out.println("Invalid sequence:" + fasta.getName() + " invalid minus stop TAA/TAG");
                        return null;
                    }
                    states[el.start - 4] = 111;
                    states[el.start - 3] = 112;
                    states[el.start - 2] = 113;
                }
            }
            if (i3 == list.size() - 1) {
                if (el.strand.equals("+")) {
                    if (fasta.getX(el.end) != T || fasta.getX(el.end + 1) != A || fasta.getX(el.end + 2) != G && fasta.getX(el.end + 2) != A) {
                        System.out.println("Invalid sequence:" + fasta.getName() + " invalid plus stop codon TAA/TAG");
                        return null;
                    }
                    states[el.end] = 108;
                    states[el.end + 1] = 109;
                    states[el.end + 2] = 110;
                } else {
                    if (fasta.getX(el.end - 3) != C && fasta.getX(el.end - 3) != T || fasta.getX(el.end - 2) != A || fasta.getX(el.end - 1) != T) {
                        System.out.println("Invalid sequence:" + fasta.getName() + " invalid minus start codon ATG/A");
                        return null;
                    }
                    states[el.end - 3] = 218;
                    states[el.end - 2] = 219;
                    states[el.end - 1] = 220;
                }
            }
            ++i3;
        }
        return states;
    }

    private boolean isInIntronPosition(int pos, ArrayList<GTFElement> list) {
        int i = 1;
        while (i < list.size()) {
            if (list.get((int)(i - 1)).end < pos && pos < list.get((int)i).start) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean isInExonPosition(int pos, ArrayList<GTFElement> list) {
        for (GTFElement el : list) {
            if (el.start > pos || pos > el.end) continue;
            return true;
        }
        return false;
    }

    private void incrementStats(InputSequence input) {
        int strand;
        InputSequence exonerate = input.getComponent(2);
        InputSequence weasel = input.getComponent(3);
        int TP = 0;
        int FP = 1;
        int TN = 2;
        int FN = 3;
        ArrayList<GTFElement> list = this.cdsMap.get(input.getName());
        int n = strand = list.get((int)0).strand.equals("+") ? 0 : 1;
        if (strand == 0) {
            ++this.plusCount;
        } else {
            ++this.minusCount;
        }
        for (GTFElement el : list) {
            this.totalExonLength += el.end - el.start + 1;
            ++this.exonCount;
        }
        int i = 1;
        while (i < list.size()) {
            this.totalIntronLength += list.get((int)i).start - list.get((int)(i - 1)).end - 1;
            ++this.intronCount;
            if ((Integer)exonerate.getX(list.get((int)(i - 1)).end) == (Integer)exonerate.getX(list.get((int)(i - 1)).end - 1) + 2) {
                ++this.exonerateAcceptorConsensuses;
            }
            if ((Integer)weasel.getX(list.get((int)(i - 1)).end) == strand + 1 && (Integer)weasel.getX(list.get((int)(i - 1)).end - 1) == 0) {
                ++this.weaselAcceptorConsensuses;
            }
            if ((Integer)exonerate.getX(list.get((int)i).start - 2) == (Integer)exonerate.getX(list.get((int)(i - 1)).start - 1) + 2) {
                ++this.exonerateDonorConsensuses;
            }
            if ((Integer)weasel.getX(list.get((int)i).start - 2) == strand + 1 && (Integer)weasel.getX(list.get((int)i).start - 1) == 0) {
                ++this.weaselDonorConsensuses;
            }
            ++i;
        }
        int pos = 0;
        while (pos < input.length()) {
            int exonerateState = (Integer)exonerate.getX(pos);
            int weaselState = (Integer)weasel.getX(pos);
            if (exonerateState == 0 || exonerateState == 3 || exonerateState == 4) {
                if (this.isInExonPosition(pos + 1, list)) {
                    int n2 = FN;
                    this.exonerateCodingStats[n2] = this.exonerateCodingStats[n2] + 1;
                } else {
                    int n3 = TN;
                    this.exonerateCodingStats[n3] = this.exonerateCodingStats[n3] + 1;
                }
            } else if (exonerateState == 1 || exonerateState == 2) {
                if (exonerateState != strand + 1) {
                    int n4 = FP;
                    this.exonerateCodingStats[n4] = this.exonerateCodingStats[n4] + 1;
                } else if (this.isInExonPosition(pos + 1, list)) {
                    int n5 = TP;
                    this.exonerateCodingStats[n5] = this.exonerateCodingStats[n5] + 1;
                    if (weaselState > 0) {
                        this.exonerateVsWeaselStats[0] = this.exonerateVsWeaselStats[0] + 1;
                    }
                } else {
                    int n6 = FP;
                    this.exonerateCodingStats[n6] = this.exonerateCodingStats[n6] + 1;
                }
            }
            if (exonerateState == 0 || exonerateState == 1 || exonerateState == 2) {
                if (this.isInIntronPosition(pos + 1, list)) {
                    int n7 = FN;
                    this.exonerateIntronStats[n7] = this.exonerateIntronStats[n7] + 1;
                } else {
                    int n8 = TN;
                    this.exonerateIntronStats[n8] = this.exonerateIntronStats[n8] + 1;
                }
            } else if (exonerateState == 3 || exonerateState == 4) {
                if (exonerateState != strand + 3) {
                    int n9 = FP;
                    this.exonerateIntronStats[n9] = this.exonerateIntronStats[n9] + 1;
                } else if (this.isInIntronPosition(pos + 1, list)) {
                    int n10 = TP;
                    this.exonerateIntronStats[n10] = this.exonerateIntronStats[n10] + 1;
                    if (weaselState > 0 && weaselState != strand + 1) {
                        this.exonerateVsWeaselStats[1] = this.exonerateVsWeaselStats[1] + 1;
                    }
                } else {
                    int n11 = FP;
                    this.exonerateIntronStats[n11] = this.exonerateIntronStats[n11] + 1;
                }
            }
            if (weaselState == 0) {
                if (this.isInIntronPosition(pos + 1, list)) {
                    int n12 = FN;
                    this.weaselStats[n12] = this.weaselStats[n12] + 1;
                } else {
                    int n13 = TN;
                    this.weaselStats[n13] = this.weaselStats[n13] + 1;
                }
            } else if (weaselState == 1 || weaselState == 2) {
                if (weaselState != strand + 1) {
                    int n14 = FP;
                    this.weaselStats[n14] = this.weaselStats[n14] + 1;
                } else if (this.isInIntronPosition(pos + 1, list)) {
                    int n15 = TP;
                    this.weaselStats[n15] = this.weaselStats[n15] + 1;
                    if (exonerateState > 0 && exonerateState != strand + 3) {
                        this.exonerateVsWeaselStats[2] = this.exonerateVsWeaselStats[2] + 1;
                    }
                } else {
                    int n16 = FP;
                    this.weaselStats[n16] = this.weaselStats[n16] + 1;
                }
            }
            ++pos;
        }
    }

    public String summarize() {
        return "---Avg lengths---\nExon:" + (double)this.totalExonLength / (double)this.exonCount + " " + this.totalExonLength + "/" + this.exonCount + "\n" + "Intron:" + (double)this.totalIntronLength / (double)this.intronCount + " " + this.totalIntronLength + "/" + this.intronCount + "\n" + "---Strand counts---\n" + "Plus:" + this.plusCount + "\n" + "Minus:" + this.minusCount + "\n" + "---Input evidence stats---\n" + "Exonerate coding:" + Util.printStats(this.exonerateCodingStats) + "Exonerate intron:" + Util.printStats(this.exonerateIntronStats) + "RNAWeasel:" + Util.printStats(this.weaselStats) + "---Exonerate vs Weasel fixes---\n" + "Exonerate coding fixed Weasel:" + this.exonerateVsWeaselStats[0] + " nucleotides\n" + "Exonerate intron fixed Weasel:" + this.exonerateVsWeaselStats[1] + " nucleotides\n" + "Weasel fixed Exonerate:" + this.exonerateVsWeaselStats[2] + " nucleotides\n" + "---Acceptro/Donor consensuses---\n" + "Exonerate acceptor;donor:" + this.exonerateAcceptorConsensuses + ";" + this.exonerateDonorConsensuses + "\n" + "Weasel acceptor;donor:" + this.weaselAcceptorConsensuses + ";" + this.weaselDonorConsensuses + "\n";
    }

    private class GTFElement
    implements Comparable {
        public int start;
        public int end;
        public String strand;
        public String gene;

        public int compareTo(Object t) {
            if (this.start < ((GTFElement)t).start) {
                return -1;
            }
            return 1;
        }

        private GTFElement() {
        }

        GTFElement(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

