/*
 * Decompiled with CFR 0.152.
 */
package mlproject.io;

import java.io.FileNotFoundException;
import java.io.IOException;
import mlproject.io.FastaIterator;
import mlproject.io.InputReader;
import mlproject.io.InputSequence;
import mlproject.io.IntegerInputSequence;

public class IntegerFastaInputReader
implements InputReader<Integer> {
    FastaIterator fi;

    public IntegerFastaInputReader(String file) throws FileNotFoundException, IOException {
        this.fi = new FastaIterator(file);
    }

    @Override
    public InputSequence<Integer> readNextSequence() throws IOException {
        String[] next = this.fi.next();
        if (next == null) {
            return null;
        }
        int[] seq = new int[next[1].length()];
        int i = 0;
        while (i < seq.length) {
            int number = next[1].charAt(i) - 48;
            if (number < 0 || number > 9) {
                throw new RuntimeException("Not a number character:" + next[1].charAt(i));
            }
            seq[i] = number;
            ++i;
        }
        return new IntegerInputSequence(next[0], seq);
    }
}

