/*
 * Decompiled with CFR 0.152.
 */
package mlproject.io;

import java.io.FileNotFoundException;
import java.io.IOException;
import mlproject.io.FastaIterator;
import mlproject.io.InputReader;
import mlproject.io.InputSequence;
import mlproject.io.IntegerInputSequence;

public class NucleotideFastaInputReader
implements InputReader<Integer> {
    FastaIterator fi;

    public NucleotideFastaInputReader(String file) throws FileNotFoundException, IOException {
        this.fi = new FastaIterator(file);
    }

    @Override
    public InputSequence<Integer> readNextSequence() throws IOException {
        String[] next = this.fi.next();
        if (next == null) {
            return null;
        }
        int[] seq = new int[next[1].length()];
        int i = 0;
        while (i < seq.length) {
            switch (next[1].charAt(i)) {
                case 'A': {
                    seq[i] = 0;
                    break;
                }
                case 'C': {
                    seq[i] = 1;
                    break;
                }
                case 'G': {
                    seq[i] = 2;
                    break;
                }
                case 'T': {
                    seq[i] = 3;
                    break;
                }
                case 'N': {
                    seq[i] = 4;
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown symbol:" + next[1].charAt(i));
                }
            }
            ++i;
        }
        return new IntegerInputSequence(next[0], seq);
    }
}

