/*
 * Decompiled with CFR 0.152.
 */
package mlproject.phylo;

import mlproject.phylo.NucleotideSubstitutionModel;

public class JukesCantorModel
extends NucleotideSubstitutionModel {
    double omega;

    public JukesCantorModel(double omega) {
        this.omega = omega;
    }

    @Override
    public double[][] getSubstitutionProbs(double time) {
        double change = (1.0 - Math.exp(-1.3333333333333333 * time * this.omega)) / 4.0;
        double same = (1.0 + 3.0 * Math.exp(-1.3333333333333333 * time * this.omega)) / 4.0;
        double[][] result = new double[4][4];
        int i = 0;
        while (i < 4) {
            int j = 0;
            while (j < 4) {
                result[i][j] = i == j ? same : change;
                ++j;
            }
            ++i;
        }
        return result;
    }
}

