/*
 * Decompiled with CFR 0.152.
 */
package mlproject.phylo;

import mlproject.phylo.NucleotideSubstitutionModel;

public class Kimura80Model
extends NucleotideSubstitutionModel {
    double ts;
    double tv;

    public Kimura80Model(double ts, double tv) {
        this.ts = ts;
        this.tv = tv;
    }

    @Override
    public double[][] getSubstitutionProbs(double time) {
        double s = (1.0 - Math.exp(-4.0 * this.tv * time)) / 4.0;
        double u = (1.0 + Math.exp(-4.0 * this.tv * time) - 2.0 * Math.exp(-2.0 * (this.ts + this.tv) * time)) / 4.0;
        double r = 1.0 - 2.0 * s - u;
        double[][] X = new double[4][4];
        int A = 0;
        int C = 1;
        int G = 2;
        int T = 3;
        X[A][A] = r;
        X[A][C] = s;
        X[A][G] = u;
        X[A][T] = s;
        X[C][A] = s;
        X[C][C] = r;
        X[C][G] = s;
        X[C][T] = u;
        X[G][A] = u;
        X[G][C] = s;
        X[G][G] = r;
        X[G][T] = s;
        X[T][A] = s;
        X[T][C] = u;
        X[T][G] = s;
        X[T][T] = r;
        return X;
    }
}

