/*
 * Decompiled with CFR 0.152.
 */
package mlproject.phylo;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import mlproject.phylo.PhylogeneticTreeNode;

public class PhylogeneticTree {
    private ArrayList<PhylogeneticTreeNode> tree;
    private int[] felsensteinOrder;
    private int[] l;
    private int[] r;
    private int[] p;
    private double[] d;
    private ArrayList<Integer> leaves;
    private HashMap<String, Integer> columnOrder;

    public int getNumberOfSpecies() {
        return this.leaves.size();
    }

    public int getSpecieIndex(String specieName) {
        Integer res = this.columnOrder.get(specieName);
        if (res == null) {
            return -1;
        }
        return res;
    }

    private static ArrayList<PhylogeneticTreeNode> parseNewickString(String newickString) {
        LinkedList<PhylogeneticTreeNode> result = new LinkedList<PhylogeneticTreeNode>();
        LinkedList<PhylogeneticTreeNode> queue = new LinkedList<PhylogeneticTreeNode>();
        int nodeId = 0;
        StringBuffer buffer = new StringBuffer();
        int ix = 0;
        block7: while (ix < newickString.length()) {
            char c = newickString.charAt(ix);
            switch (c) {
                case '(': {
                    PhylogeneticTreeNode node = new PhylogeneticTreeNode();
                    node.i = nodeId;
                    node.n = buffer.toString();
                    if (!queue.isEmpty()) {
                        node.p = ((PhylogeneticTreeNode)queue.getLast()).i;
                        if (((PhylogeneticTreeNode)queue.getLast()).l == -1) {
                            ((PhylogeneticTreeNode)queue.getLast()).l = nodeId;
                        } else if (((PhylogeneticTreeNode)queue.getLast()).r == -1) {
                            ((PhylogeneticTreeNode)queue.getLast()).r = nodeId;
                        } else {
                            throw new RuntimeException("bad newick input");
                        }
                    }
                    result.add(node);
                    queue.add(node);
                    ++nodeId;
                    buffer = new StringBuffer();
                    break;
                }
                case ':': {
                    if (buffer.length() == 0) break;
                    PhylogeneticTreeNode node = new PhylogeneticTreeNode();
                    node.i = nodeId;
                    node.n = buffer.toString();
                    if (!queue.isEmpty()) {
                        node.p = ((PhylogeneticTreeNode)queue.getLast()).i;
                        if (((PhylogeneticTreeNode)queue.getLast()).l == -1) {
                            ((PhylogeneticTreeNode)queue.getLast()).l = nodeId;
                        } else if (((PhylogeneticTreeNode)queue.getLast()).r == -1) {
                            ((PhylogeneticTreeNode)queue.getLast()).r = nodeId;
                        } else {
                            throw new RuntimeException("bad newick input");
                        }
                    }
                    result.add(node);
                    queue.add(node);
                    ++nodeId;
                    buffer = new StringBuffer();
                    break;
                }
                case ',': {
                    PhylogeneticTreeNode node = (PhylogeneticTreeNode)queue.removeLast();
                    node.d = Double.parseDouble(buffer.toString());
                    buffer = new StringBuffer();
                    break;
                }
                case ')': {
                    PhylogeneticTreeNode node = (PhylogeneticTreeNode)queue.removeLast();
                    node.d = Double.parseDouble(buffer.toString());
                    buffer = new StringBuffer();
                    break;
                }
                case ';': {
                    PhylogeneticTreeNode node = (PhylogeneticTreeNode)queue.removeLast();
                    if (buffer.length() > 0) {
                        node.d = Double.parseDouble(buffer.toString());
                    }
                    if (queue.isEmpty()) break block7;
                    throw new RuntimeException("bad newick input");
                }
                default: {
                    buffer.append(c);
                }
            }
            ++ix;
        }
        return new ArrayList<PhylogeneticTreeNode>(result);
    }

    public PhylogeneticTree(String newickString) {
        this.tree = PhylogeneticTree.parseNewickString(newickString.trim());
        this.leaves = new ArrayList();
        this.columnOrder = new HashMap();
        this.felsensteinOrder = new int[this.tree.size()];
        int i = 0;
        while (i < this.tree.size()) {
            PhylogeneticTreeNode node = this.tree.get(i);
            if (node.l * node.r < 0) {
                throw new RuntimeException("Non binary node:" + node);
            }
            if (node.l == -1) {
                this.leaves.add(i);
                this.columnOrder.put(node.n, this.leaves.size() - 1);
            }
            ++i;
        }
        this.felsensteinOrder = this.calculateFelsensteinOrder();
        this.l = new int[this.tree.size()];
        this.r = new int[this.tree.size()];
        this.p = new int[this.tree.size()];
        this.d = new double[this.tree.size()];
        int i2 = 0;
        while (i2 < this.tree.size()) {
            this.l[i2] = this.tree.get((int)i2).l;
            this.r[i2] = this.tree.get((int)i2).r;
            this.p[i2] = this.tree.get((int)i2).p;
            this.d[i2] = this.tree.get((int)i2).d;
            ++i2;
        }
    }

    private int[] calculateFelsensteinOrder() {
        LinkedList<Integer> queue = new LinkedList<Integer>();
        int[] res = new int[this.tree.size()];
        int ix = this.tree.size() - 1;
        queue.add(0);
        while (queue.size() != 0) {
            PhylogeneticTreeNode node = this.tree.get((Integer)queue.removeFirst());
            if (node.l == -1) continue;
            queue.add(node.l);
            res[--ix] = node.l;
            queue.add(node.r);
            res[--ix] = node.r;
        }
        return res;
    }

    public ArrayList<PhylogeneticTreeNode> getTree() {
        return this.tree;
    }

    public int[] getFelsensteinOrder() {
        return this.felsensteinOrder;
    }

    public int[] getLeaves() {
        int[] result = new int[this.leaves.size()];
        int i = 0;
        while (i < this.leaves.size()) {
            result[i] = this.leaves.get(i);
            ++i;
        }
        return result;
    }

    public void setFelsensteinOrder(int[] felsensteinOrder) {
        this.felsensteinOrder = felsensteinOrder;
    }

    public int[] getL() {
        return this.l;
    }

    public int[] getR() {
        return this.r;
    }

    public int[] getP() {
        return this.p;
    }

    public double[] getD() {
        return this.d;
    }
}

