/*
 * Decompiled with CFR 0.152.
 */
package mlproject.hmm;

import java.util.Arrays;
import java.util.List;
import mlproject.hmm.EmissionModel;
import mlproject.hmm.StateModel;
import mlproject.io.InputSequence;
import mlproject.io.TrainingSequence;
import mlproject.phylo.EvolutionaryModel;

public class EvidenceEmissionModel
extends EmissionModel {
    private int pseudoCount = 1;
    private int emissionModelType = 1;
    private double[][] stateLogProbs;
    private double[][] exonerateLogProbs;
    private double[][] rnaweaselLogProbs;
    private int nStates;
    private StateModel stateModel;
    EvolutionaryModel emodelIntergenic;
    EvolutionaryModel emodelIntronic;
    List<EvolutionaryModel> emodelExonic;
    EvolutionaryModel[] emodelStateMapping;

    @Override
    public double emissionLogProb(int state, int pos, InputSequence input) {
        int nucleotide = (Integer)input.getComponent(0).getX(pos);
        if (this.emissionModelType == 1) {
            return nucleotide == 4 ? 0.0 : this.stateLogProbs[state][nucleotide] + this.emodelStateMapping[state].getColumnLogProbability((String)input.getComponent(1).getX(pos), state >= this.stateModel.getFirstMinusState()) + this.exonerateLogProbs[state][(Integer)input.getComponent(2).getX(pos)] + this.rnaweaselLogProbs[state][(Integer)input.getComponent(3).getX(pos)];
        }
        if (this.emissionModelType == 2) {
            return nucleotide == 4 ? 0.0 : this.stateLogProbs[state][nucleotide] + this.emodelStateMapping[state].getColumnLogProbability((String)input.getComponent(1).getX(pos), state >= this.stateModel.getFirstMinusState()) + this.rnaweaselLogProbs[state][(Integer)input.getComponent(3).getX(pos)];
        }
        if (this.emissionModelType == 3) {
            return nucleotide == 4 ? 0.0 : this.stateLogProbs[state][nucleotide] + this.exonerateLogProbs[state][(Integer)input.getComponent(2).getX(pos)] + this.rnaweaselLogProbs[state][(Integer)input.getComponent(3).getX(pos)];
        }
        if (this.emissionModelType == 4) {
            return nucleotide == 4 ? 0.0 : this.stateLogProbs[state][nucleotide] + this.emodelStateMapping[state].getColumnLogProbability((String)input.getComponent(1).getX(pos), state >= this.stateModel.getFirstMinusState()) + this.exonerateLogProbs[state][(Integer)input.getComponent(2).getX(pos)];
        }
        if (this.emissionModelType == 5) {
            return nucleotide == 4 ? 0.0 : this.stateLogProbs[state][nucleotide] + this.exonerateLogProbs[state][(Integer)input.getComponent(2).getX(pos)];
        }
        if (this.emissionModelType == 6) {
            return nucleotide == 4 ? 0.0 : this.stateLogProbs[state][nucleotide] + this.emodelStateMapping[state].getColumnLogProbability((String)input.getComponent(1).getX(pos), state >= this.stateModel.getFirstMinusState());
        }
        if (this.emissionModelType == 7) {
            return nucleotide == 4 ? 0.0 : this.stateLogProbs[state][nucleotide] + this.rnaweaselLogProbs[state][(Integer)input.getComponent(3).getX(pos)];
        }
        return nucleotide == 4 ? 0.0 : this.stateLogProbs[state][nucleotide];
    }

    @Override
    public void train(StateModel stateModel, List<TrainingSequence> trainingSequences) {
        this.stateModel = stateModel;
        this.nStates = stateModel.getNStates();
        this.stateLogProbs = new double[this.nStates][4];
        this.exonerateLogProbs = new double[this.nStates][5];
        this.rnaweaselLogProbs = new double[this.nStates][3];
        this.initializeEvolutionaryModels();
        int i = 0;
        while (i < this.nStates) {
            Arrays.fill(this.stateLogProbs[i], (double)this.pseudoCount);
            Arrays.fill(this.exonerateLogProbs[i], (double)this.pseudoCount);
            Arrays.fill(this.rnaweaselLogProbs[i], (double)this.pseudoCount);
            ++i;
        }
        for (TrainingSequence ti : trainingSequences) {
            InputSequence input = ti.getInputSequence();
            int i2 = 0;
            while (i2 < ti.length() - 1) {
                if ((Integer)input.getComponent(0).getX(i2) < 4) {
                    double[] dArray = this.stateLogProbs[ti.getY(i2)];
                    int n = (Integer)input.getComponent(0).getX(i2);
                    dArray[n] = dArray[n] + 1.0;
                }
                double[] dArray = this.exonerateLogProbs[ti.getY(i2)];
                int n = (Integer)input.getComponent(2).getX(i2);
                dArray[n] = dArray[n] + 1.0;
                double[] dArray2 = this.rnaweaselLogProbs[ti.getY(i2)];
                int n2 = (Integer)input.getComponent(3).getX(i2);
                dArray2[n2] = dArray2[n2] + 1.0;
                ++i2;
            }
        }
        this.fixJoinedEmissions();
        this.fixCounts();
        double coef = 1.0;
        int i3 = 0;
        while (i3 < this.nStates) {
            double stateRowCount = 0.0;
            double exonerateRowCount = 0.0;
            double weaselRowCount = 0.0;
            int j = 0;
            while (j < 4) {
                stateRowCount += this.stateLogProbs[i3][j];
                ++j;
            }
            int j2 = 0;
            while (j2 < 3) {
                weaselRowCount += this.rnaweaselLogProbs[i3][j2];
                ++j2;
            }
            int j3 = 0;
            while (j3 < 5) {
                exonerateRowCount += this.exonerateLogProbs[i3][j3];
                ++j3;
            }
            int j4 = 0;
            while (j4 < 4) {
                this.stateLogProbs[i3][j4] = this.stateLogProbs[i3][j4] == 0.0 ? Double.NEGATIVE_INFINITY : Math.log(this.stateLogProbs[i3][j4] / stateRowCount) * coef;
                ++j4;
            }
            int j5 = 0;
            while (j5 < 3) {
                this.rnaweaselLogProbs[i3][j5] = Math.log(this.rnaweaselLogProbs[i3][j5] / weaselRowCount) * 0.5;
                ++j5;
            }
            int j6 = 0;
            while (j6 < 5) {
                this.exonerateLogProbs[i3][j6] = Math.log(this.exonerateLogProbs[i3][j6] / exonerateRowCount);
                ++j6;
            }
            ++i3;
        }
    }

    private void initializeEvolutionaryModels() {
        this.emodelStateMapping = new EvolutionaryModel[this.nStates];
        int i = 0;
        while (i < this.stateModel.getIntergenicStates().length) {
            this.emodelStateMapping[this.stateModel.getIntergenicStates()[i]] = this.emodelIntergenic;
            ++i;
        }
        int i2 = 0;
        while (i2 < this.stateModel.getPlusIntronicStates().length) {
            this.emodelStateMapping[this.stateModel.getPlusIntronicStates()[i2]] = this.emodelIntronic;
            ++i2;
        }
        int i3 = 0;
        while (i3 < this.stateModel.getMinusIntronicStates().length) {
            this.emodelStateMapping[this.stateModel.getMinusIntronicStates()[i3]] = this.emodelIntronic;
            ++i3;
        }
        int i4 = 0;
        while (i4 < this.stateModel.getPlusExon0States().length) {
            this.emodelStateMapping[this.stateModel.getPlusExon0States()[i4]] = this.emodelExonic.get(0);
            ++i4;
        }
        int i5 = 0;
        while (i5 < this.stateModel.getMinusExon0States().length) {
            this.emodelStateMapping[this.stateModel.getMinusExon0States()[i5]] = this.emodelExonic.get(0);
            ++i5;
        }
        int i6 = 0;
        while (i6 < this.stateModel.getPlusExon1States().length) {
            this.emodelStateMapping[this.stateModel.getPlusExon1States()[i6]] = this.emodelExonic.get(1);
            ++i6;
        }
        int i7 = 0;
        while (i7 < this.stateModel.getMinusExon1States().length) {
            this.emodelStateMapping[this.stateModel.getMinusExon1States()[i7]] = this.emodelExonic.get(1);
            ++i7;
        }
        int i8 = 0;
        while (i8 < this.stateModel.getPlusExon2States().length) {
            this.emodelStateMapping[this.stateModel.getPlusExon2States()[i8]] = this.emodelExonic.get(2);
            ++i8;
        }
        int i9 = 0;
        while (i9 < this.stateModel.getMinusExon2States().length) {
            this.emodelStateMapping[this.stateModel.getMinusExon2States()[i9]] = this.emodelExonic.get(2);
            ++i9;
        }
    }

    private void fixCounts() {
        int[][] constraints = this.stateModel.getFixedStateNucleotideCounts();
        int i = 0;
        while (i < this.nStates) {
            int j = 0;
            while (j < 4) {
                if (constraints[i][j] == -1) {
                    this.stateLogProbs[i][j] = 0.0;
                }
                if (constraints[i][j] == 1) {
                    this.stateLogProbs[i][j] = 1.0;
                    int k = 0;
                    while (k < 4) {
                        if (j != k) {
                            this.stateLogProbs[i][k] = 0.0;
                        }
                        ++k;
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    private void fixJoinedEmissions() {
        int[][] joined = this.stateModel.getJoinedEmissionStates();
        int i = 0;
        while (i < joined.length) {
            double[] counts = new double[4];
            double[] exonerateCounts = new double[5];
            double[] weaselCounts = new double[3];
            int j = 0;
            while (j < joined[i].length) {
                int k = 0;
                while (k < 4) {
                    int n = k;
                    counts[n] = counts[n] + this.stateLogProbs[joined[i][j]][k];
                    ++k;
                }
                int k2 = 0;
                while (k2 < 5) {
                    int n = k2;
                    exonerateCounts[n] = exonerateCounts[n] + this.exonerateLogProbs[joined[i][j]][k2];
                    ++k2;
                }
                int k3 = 0;
                while (k3 < 3) {
                    int n = k3;
                    weaselCounts[n] = weaselCounts[n] + this.rnaweaselLogProbs[joined[i][j]][k3];
                    ++k3;
                }
                ++j;
            }
            int j2 = 0;
            while (j2 < joined[i].length) {
                int k = 0;
                while (k < 4) {
                    this.stateLogProbs[joined[i][j2]][k] = counts[k];
                    ++k;
                }
                int k4 = 0;
                while (k4 < 5) {
                    this.exonerateLogProbs[joined[i][j2]][k4] = exonerateCounts[k4];
                    ++k4;
                }
                int k5 = 0;
                while (k5 < 3) {
                    this.rnaweaselLogProbs[joined[i][j2]][k5] = weaselCounts[k5];
                    ++k5;
                }
                ++j2;
            }
            ++i;
        }
    }

    public void setEmodelIntergenic(EvolutionaryModel emodelIntergenic) {
        this.emodelIntergenic = emodelIntergenic;
    }

    public EvolutionaryModel getEmodelIntergenic() {
        return this.emodelIntergenic;
    }

    public void setEmodelIntronic(EvolutionaryModel emodelIntronic) {
        this.emodelIntronic = emodelIntronic;
    }

    public EvolutionaryModel getEmodelIntronic() {
        return this.emodelIntronic;
    }

    public void setEmodelExonic(List<EvolutionaryModel> emodelExonic) {
        this.emodelExonic = emodelExonic;
    }

    public List<EvolutionaryModel> getEmodelExonic() {
        return this.emodelExonic;
    }

    public void setEmissionModelType(int emissionModel) {
        this.emissionModelType = emissionModel;
    }

    public int getEmissionModelType() {
        return this.emissionModelType;
    }
}

