/*
 * Decompiled with CFR 0.152.
 */
package mlproject.io;

import java.io.FileNotFoundException;
import java.io.IOException;
import mlproject.io.InputReader;
import mlproject.io.InputSequence;
import mlproject.io.InputSequenceComposite;
import mlproject.io.IntegerFastaInputReader;
import mlproject.io.MultipleAlignmentReader;
import mlproject.io.NucleotideFastaInputReader;
import mlproject.phylo.PhylogeneticTree;

public class EvidenceCompositeInputReader
implements InputReader {
    private NucleotideFastaInputReader fr;
    private MultipleAlignmentReader mr;
    private IntegerFastaInputReader er;
    private IntegerFastaInputReader wr;

    public EvidenceCompositeInputReader(String fastaFile, PhylogeneticTree tree, String alignmentFile, String exonerateFile, String weaselFile) throws FileNotFoundException, IOException {
        this.fr = new NucleotideFastaInputReader(fastaFile);
        this.mr = new MultipleAlignmentReader(alignmentFile, tree);
        this.er = new IntegerFastaInputReader(exonerateFile);
        this.wr = new IntegerFastaInputReader(weaselFile);
    }

    public InputSequence readNextSequence() throws IOException {
        InputSequenceComposite result = new InputSequenceComposite();
        result.addComponent(this.fr.readNextSequence());
        result.addComponent(this.mr.readNextSequence());
        result.addComponent(this.er.readNextSequence());
        result.addComponent(this.wr.readNextSequence());
        int nullCount = 0;
        int i = 0;
        while (i < 4) {
            if (result.getComponent(i) == null) {
                ++nullCount;
            }
            ++i;
        }
        if (nullCount == 4) {
            return null;
        }
        if (nullCount > 0) {
            throw new RuntimeException("Incorrect number of input sequences in composite");
        }
        int i2 = 1;
        while (i2 < 4) {
            if (result.getComponent(i2).length() != result.getComponent(i2 - 1).length()) {
                throw new RuntimeException("Incorrect size of input sequence");
            }
            ++i2;
        }
        return result;
    }
}

