/*
 * Decompiled with CFR 0.152.
 */
package mlproject.io;

import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import mlproject.hmm.StateModel;

public class GTFWriter {
    PrintWriter pw;
    StateModel stateModel;

    public GTFWriter(StateModel stateModel, String outputFile) throws IOException {
        this.stateModel = stateModel;
        this.pw = new PrintWriter(new FileWriter(outputFile));
    }

    public void writeStates(String name, int[] states) {
        int[][] stateTypes = new int[][]{this.stateModel.getIntergenicStates(), this.stateModel.getPlusStartCodonStates(), this.stateModel.getPlusExonicStates(), this.stateModel.getPlusStopCodonStates(), this.stateModel.getMinusStopCodonStates(), this.stateModel.getMinusStartCodonStates(), this.stateModel.getMinusExonicStates()};
        int start = 0;
        int frame = 0;
        int geneCount = 1;
        int lastType = this.getStateType(stateTypes, states[0]);
        int i = 1;
        while (i < states.length) {
            int currentType = this.getStateType(stateTypes, states[i]);
            if (currentType != lastType) {
                if (currentType == 0) {
                    frame = 0;
                }
                if (currentType == 1) {
                    start = i;
                    this.pw.println(this.getGtfLine(name, "start_codon", i + 1, i + 3, "+", ".", geneCount));
                }
                if (currentType == 4) {
                    start = i + 3;
                    this.pw.println(this.getGtfLine(name, "stop_codon", i + 1, i + 3, "-", ".", geneCount));
                }
                if (currentType == 5) {
                    frame = (i - start + 1 - (3 - frame) % 3) % 3;
                    this.pw.println(this.getGtfLine(name, "CDS", start + 1, i + 3, "-", Integer.toString(frame), geneCount));
                    this.pw.println(this.getGtfLine(name, "start_codon", i + 1, i + 3, "-", ".", geneCount));
                    ++geneCount;
                }
                if (currentType == 3) {
                    this.pw.println(this.getGtfLine(name, "CDS", start + 1, i, "+", Integer.toString(frame), geneCount));
                    this.pw.println(this.getGtfLine(name, "stop_codon", i + 1, i + 3, "+", ".", geneCount));
                    ++geneCount;
                }
                if (currentType == -1) {
                    if (lastType == 2) {
                        this.pw.println(this.getGtfLine(name, "CDS", start + 1, i, "+", Integer.toString(frame), geneCount));
                        frame = (3 - (i - start + 1 - frame) % 3) % 3;
                    }
                    if (lastType == 6) {
                        frame = (i - start + 1 - (3 - frame) % 3) % 3;
                        this.pw.println(this.getGtfLine(name, "CDS", start + 1, i, "-", Integer.toString(frame), geneCount));
                    }
                }
                if ((currentType == 2 || currentType == 6) && lastType == -1) {
                    start = i;
                }
                lastType = currentType;
            }
            ++i;
        }
    }

    private String getGtfLine(String name, String type, int start, int stop, String strand, String frame, int geneId) {
        return name + "\t" + ".\t" + type + "\t" + start + "\t" + stop + "\t.\t" + strand + "\t" + frame + "\t" + "gene_id \"" + name + "_" + geneId + "\"; transcript_id \"" + name + "_" + geneId + "\";";
    }

    private int getStateType(int[][] stateTypes, int state) {
        int i = 0;
        while (i < stateTypes.length) {
            int j = 0;
            while (j < stateTypes[i].length) {
                if (stateTypes[i][j] == state) {
                    return i;
                }
                ++j;
            }
            ++i;
        }
        return -1;
    }

    public void close() {
        this.pw.close();
    }
}

