/*
 * Decompiled with CFR 0.152.
 */
package mlproject.io;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.LinkedList;
import mlproject.io.FastaIterator;
import mlproject.io.InputReader;
import mlproject.io.InputSequence;
import mlproject.io.StringInputSequence;
import mlproject.phylo.PhylogeneticTree;

public class MultipleAlignmentReader
implements InputReader<String> {
    PhylogeneticTree tree;
    FastaIterator fi;
    String currentAlignmentName;
    int currentOrganismIx;
    String[] sequences;

    public MultipleAlignmentReader(String file, PhylogeneticTree tree) throws FileNotFoundException, IOException {
        this.tree = tree;
        this.fi = new FastaIterator(file);
        String[] nextSeq = this.fi.next();
        if (nextSeq == null) {
            return;
        }
        String[] fields = nextSeq[0].split(" ");
        this.sequences = new String[tree.getNumberOfSpecies()];
        this.currentOrganismIx = tree.getSpecieIndex(fields[0].split("_")[0]);
        this.currentAlignmentName = fields[0];
        this.sequences[this.currentOrganismIx] = nextSeq[1];
    }

    @Override
    public InputSequence<String> readNextSequence() throws IOException {
        String[] fields;
        String[] nextSeq;
        if (this.currentAlignmentName == null) {
            return null;
        }
        StringInputSequence result = null;
        while (true) {
            if ((nextSeq = this.fi.next()) == null || !nextSeq[0].split(" ")[0].equals(this.currentAlignmentName)) {
                LinkedList<String> resultSeq = new LinkedList<String>();
                int i = 0;
                while (i < this.sequences[this.currentOrganismIx].length()) {
                    if (this.sequences[this.currentOrganismIx].charAt(i) != '-') {
                        StringBuffer buffer = new StringBuffer();
                        int j = 0;
                        while (j < this.sequences.length) {
                            if (this.sequences[j] == null) {
                                buffer.append('-');
                            } else {
                                buffer.append(this.sequences[j].charAt(i));
                            }
                            ++j;
                        }
                        resultSeq.add(buffer.toString());
                    }
                    ++i;
                }
                result = new StringInputSequence(this.currentAlignmentName, resultSeq.toArray(new String[0]));
            }
            if (nextSeq == null) {
                this.currentAlignmentName = null;
                return result;
            }
            fields = nextSeq[0].split(" ");
            if (!fields[0].equals(this.currentAlignmentName)) break;
            this.sequences[this.tree.getSpecieIndex((String)fields[1])] = nextSeq[1];
        }
        this.sequences = new String[this.tree.getNumberOfSpecies()];
        this.currentOrganismIx = this.tree.getSpecieIndex(fields[0].split("_")[0]);
        this.currentAlignmentName = fields[0];
        this.sequences[this.currentOrganismIx] = nextSeq[1];
        return result;
    }
}

