/*
 * Decompiled with CFR 0.152.
 */
package mlproject.phylo;

import java.util.Arrays;
import java.util.HashMap;
import mlproject.phylo.NucleotideSubstitutionModel;
import mlproject.phylo.PhylogeneticTree;

public class EvolutionaryModel {
    double[] pi;
    int[] felsensteinOrder;
    int[] l;
    int[] r;
    double[] d;
    int[] leaves;
    double[][] substitutionProbsL;
    double[][] substitutionProbsR;
    double[][] probTable;
    private HashMap<String, Double> computedColumns = new HashMap();

    public EvolutionaryModel(PhylogeneticTree tree, double[] pi, NucleotideSubstitutionModel model) {
        this.pi = pi;
        this.felsensteinOrder = tree.getFelsensteinOrder();
        this.l = tree.getL();
        this.r = tree.getR();
        this.d = tree.getD();
        this.leaves = tree.getLeaves();
        this.probTable = new double[this.felsensteinOrder.length][4];
        this.substitutionProbsL = new double[this.felsensteinOrder.length][16];
        this.substitutionProbsR = new double[this.felsensteinOrder.length][16];
        int[] p = tree.getP();
        int i = 0;
        while (i < p.length) {
            if (p[i] != -1) {
                double[][] probs = model.getSubstitutionProbs(this.d[i]);
                if (i == this.l[p[i]]) {
                    int x = 0;
                    while (x < 4) {
                        int y = 0;
                        while (y < 4) {
                            this.substitutionProbsL[p[i]][x * 4 + y] = probs[x][y];
                            ++y;
                        }
                        ++x;
                    }
                } else {
                    int x = 0;
                    while (x < 4) {
                        int y = 0;
                        while (y < 4) {
                            this.substitutionProbsR[p[i]][x * 4 + y] = probs[x][y];
                            ++y;
                        }
                        ++x;
                    }
                }
            }
            ++i;
        }
    }

    public double getColumnLogProbability(String column, boolean complement) {
        Double logprob = this.computedColumns.get(column);
        if (logprob != null) {
            return logprob;
        }
        if (column.length() != this.leaves.length) {
            throw new RuntimeException("Incorrect size of column");
        }
        if (complement) {
            int i = 0;
            while (i < this.leaves.length) {
                Arrays.fill(this.probTable[this.leaves[i]], 0.0);
                switch (column.charAt(i)) {
                    case 'A': {
                        this.probTable[this.leaves[i]][3] = 1.0;
                        break;
                    }
                    case 'C': {
                        this.probTable[this.leaves[i]][2] = 1.0;
                        break;
                    }
                    case 'G': {
                        this.probTable[this.leaves[i]][1] = 1.0;
                        break;
                    }
                    case 'T': {
                        this.probTable[this.leaves[i]][0] = 1.0;
                        break;
                    }
                    default: {
                        Arrays.fill(this.probTable[this.leaves[i]], 1.0);
                    }
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.leaves.length) {
                Arrays.fill(this.probTable[this.leaves[i]], 0.0);
                switch (column.charAt(i)) {
                    case 'A': {
                        this.probTable[this.leaves[i]][0] = 1.0;
                        break;
                    }
                    case 'C': {
                        this.probTable[this.leaves[i]][1] = 1.0;
                        break;
                    }
                    case 'G': {
                        this.probTable[this.leaves[i]][2] = 1.0;
                        break;
                    }
                    case 'T': {
                        this.probTable[this.leaves[i]][3] = 1.0;
                        break;
                    }
                    default: {
                        Arrays.fill(this.probTable[this.leaves[i]], 1.0);
                    }
                }
                ++i;
            }
        }
        int i = 2;
        while (i < this.felsensteinOrder.length) {
            int currentNode = this.felsensteinOrder[i];
            if (this.l[currentNode] != -1) {
                int j = 0;
                while (j < 4) {
                    double probLeft = 0.0;
                    double probRight = 0.0;
                    int k = 0;
                    while (k < 4) {
                        probLeft += this.substitutionProbsL[currentNode][j * 4 + k] * this.probTable[this.l[currentNode]][k];
                        probRight += this.substitutionProbsR[currentNode][j * 4 + k] * this.probTable[this.r[currentNode]][k];
                        ++k;
                    }
                    this.probTable[currentNode][j] = probLeft * probRight;
                    ++j;
                }
            }
            ++i;
        }
        logprob = Math.log((this.pi[0] * this.probTable[0][0] + this.pi[1] * this.probTable[0][1] + this.pi[2] * this.probTable[0][2] + this.pi[3] * this.probTable[0][3]) / 4.0);
        this.computedColumns.put(column, logprob);
        return logprob;
    }
}

