/*
 * Decompiled with CFR 0.152.
 */
package mlproject.stats;

import java.text.DecimalFormat;
import mlproject.hmm.StateModel;
import mlproject.io.TrainingSequence;
import mlproject.util.Util;

public class Statistics {
    private StateModel model;
    private int totalLength = 0;
    private int totalPlusExonLength = 0;
    private int totalMinusExonLength = 0;
    private int totalStateMatches = 0;
    private int totalSequences = 0;
    private int perfectlyPredictedSequences = 0;
    private int totalPlusExonStateMatches = 0;
    private int totalMinusExonStateMatches = 0;
    private int totalReversePlusExonLength = 0;
    private int totalReverseMinusExonLength = 0;
    private int totalReversePlusExonStateMatches = 0;
    private int totalReverseMinusExonStateMatches = 0;
    int[] intergenicStateStats = new int[4];
    int[] plusExonStateStats = new int[4];
    int[] minusExonStateStats = new int[4];
    int[] plusIntronStateStats = new int[4];
    int[] minusIntronStateStats = new int[4];
    int[] plusExonStats = new int[4];
    int[] minusExonStats = new int[4];
    int[] plusIntronStats = new int[4];
    int[] minusIntronStats = new int[4];
    int TP = 0;
    int FP = 1;
    int TN = 2;
    int FN = 3;

    public Statistics(StateModel model) {
        this.model = model;
    }

    private void incrementStats(int[] statsArray, boolean predicted, boolean actual) {
        if (predicted && actual) {
            int n = this.TP;
            statsArray[n] = statsArray[n] + 1;
        }
        if (predicted && !actual) {
            int n = this.FP;
            statsArray[n] = statsArray[n] + 1;
        }
        if (!predicted && !actual) {
            int n = this.TN;
            statsArray[n] = statsArray[n] + 1;
        }
        if (!predicted && actual) {
            int n = this.FN;
            statsArray[n] = statsArray[n] + 1;
        }
    }

    public void addTrainingSequence(TrainingSequence seq, int[] states) {
        this.totalLength += states.length;
        ++this.totalSequences;
        boolean foundMismatch = false;
        boolean readingPredictedExon = false;
        boolean readingActualExon = false;
        int predictedStrand = 0;
        int actualStrand = 0;
        int predictedExonStart = 0;
        int actualExonStart = 0;
        boolean readingPredictedIntron = false;
        boolean readingActualIntron = false;
        int predictedIntronStart = 0;
        int actualIntronStart = 0;
        int i = 0;
        while (i < seq.length()) {
            int state = states[i];
            int stateY = seq.getY(i);
            if (state == stateY) {
                ++this.totalStateMatches;
            } else {
                foundMismatch = true;
            }
            this.incrementStats(this.intergenicStateStats, Util.containsElement(this.model.getIntergenicStates(), state), Util.containsElement(this.model.getIntergenicStates(), stateY));
            this.incrementStats(this.plusExonStateStats, Util.containsElement(this.model.getPlusExonicStates(), state), Util.containsElement(this.model.getPlusExonicStates(), stateY));
            this.incrementStats(this.minusExonStateStats, Util.containsElement(this.model.getMinusExonicStates(), state), Util.containsElement(this.model.getMinusExonicStates(), stateY));
            this.incrementStats(this.plusIntronStateStats, Util.containsElement(this.model.getPlusIntronicStates(), state), Util.containsElement(this.model.getPlusIntronicStates(), stateY));
            this.incrementStats(this.minusIntronStateStats, Util.containsElement(this.model.getMinusIntronicStates(), state), Util.containsElement(this.model.getMinusIntronicStates(), stateY));
            if (Util.containsElement(this.model.getPlusExonicStates(), stateY)) {
                ++this.totalPlusExonLength;
                if (state == stateY) {
                    ++this.totalPlusExonStateMatches;
                }
            }
            if (Util.containsElement(this.model.getMinusExonicStates(), stateY)) {
                ++this.totalMinusExonLength;
                if (state == stateY) {
                    ++this.totalMinusExonStateMatches;
                }
            }
            if (Util.containsElement(this.model.getPlusExonicStates(), state)) {
                ++this.totalReversePlusExonLength;
                if (state == stateY) {
                    ++this.totalReversePlusExonStateMatches;
                }
            }
            if (Util.containsElement(this.model.getMinusExonicStates(), state)) {
                ++this.totalReverseMinusExonLength;
                if (state == stateY) {
                    ++this.totalReverseMinusExonStateMatches;
                }
            }
            if (Util.containsElement(this.model.getPlusExonicStates(), state) && !readingPredictedExon) {
                readingPredictedExon = true;
                predictedExonStart = i;
                predictedStrand = 1;
            }
            if (Util.containsElement(this.model.getMinusExonicStates(), state) && !readingPredictedExon) {
                readingPredictedExon = true;
                predictedExonStart = i;
                predictedStrand = -1;
            }
            if (!Util.containsElement(this.model.getPlusExonicStates(), state) && !Util.containsElement(this.model.getMinusExonicStates(), state)) {
                if (readingPredictedExon) {
                    readingPredictedExon = false;
                    boolean foundConflict = false;
                    if (predictedStrand == 1) {
                        int j = predictedExonStart;
                        while (j < i) {
                            if (!Util.containsElement(this.model.getPlusExonicStates(), seq.getY(j))) {
                                foundConflict = true;
                                break;
                            }
                            ++j;
                        }
                        if (predictedExonStart == 0 ? true : !Util.containsElement(this.model.getPlusExonicStates(), seq.getY(predictedExonStart - 1)) && !Util.containsElement(this.model.getPlusExonicStates(), seq.getY(i)) && !foundConflict) {
                            int n = this.TP;
                            this.plusExonStats[n] = this.plusExonStats[n] + 1;
                        } else {
                            int n = this.FP;
                            this.plusExonStats[n] = this.plusExonStats[n] + 1;
                        }
                    } else {
                        int j = predictedExonStart;
                        while (j < i) {
                            if (!Util.containsElement(this.model.getMinusExonicStates(), seq.getY(j))) {
                                foundConflict = true;
                                break;
                            }
                            ++j;
                        }
                        if (predictedExonStart == 0 ? true : !Util.containsElement(this.model.getMinusExonicStates(), seq.getY(predictedExonStart - 1)) && !Util.containsElement(this.model.getMinusExonicStates(), seq.getY(i)) && !foundConflict) {
                            int n = this.TP;
                            this.minusExonStats[n] = this.minusExonStats[n] + 1;
                        } else {
                            int n = this.FP;
                            this.minusExonStats[n] = this.minusExonStats[n] + 1;
                        }
                    }
                }
            } else if (i == seq.length()) {
                boolean foundConflict = false;
                if (predictedStrand == 1) {
                    int j = predictedExonStart;
                    while (j < i + 1) {
                        if (!Util.containsElement(this.model.getPlusExonicStates(), seq.getY(j))) {
                            foundConflict = true;
                            break;
                        }
                        ++j;
                    }
                    if (predictedExonStart == 0 ? true : !Util.containsElement(this.model.getPlusExonicStates(), seq.getY(predictedExonStart - 1)) && !foundConflict) {
                        int n = this.TP;
                        this.plusExonStats[n] = this.plusExonStats[n] + 1;
                    } else {
                        int n = this.FP;
                        this.plusExonStats[n] = this.plusExonStats[n] + 1;
                    }
                } else {
                    int j = predictedExonStart;
                    while (j < i + 1) {
                        if (!Util.containsElement(this.model.getMinusExonicStates(), seq.getY(j))) {
                            foundConflict = true;
                            break;
                        }
                        ++j;
                    }
                    if (predictedExonStart == 0 ? true : !Util.containsElement(this.model.getMinusExonicStates(), seq.getY(predictedExonStart - 1)) && !foundConflict) {
                        int n = this.TP;
                        this.minusExonStats[n] = this.minusExonStats[n] + 1;
                    } else {
                        int n = this.FP;
                        this.minusExonStats[n] = this.minusExonStats[n] + 1;
                    }
                }
            }
            if (Util.containsElement(this.model.getPlusExonicStates(), stateY) && !readingActualExon) {
                readingActualExon = true;
                actualExonStart = i;
                actualStrand = 1;
            }
            if (Util.containsElement(this.model.getMinusExonicStates(), stateY) && !readingActualExon) {
                readingActualExon = true;
                actualExonStart = i;
                actualStrand = -1;
            }
            if (!Util.containsElement(this.model.getPlusExonicStates(), stateY) && !Util.containsElement(this.model.getMinusExonicStates(), stateY)) {
                if (readingActualExon) {
                    readingActualExon = false;
                    boolean foundConflict = false;
                    if (actualStrand == 1) {
                        int j = actualExonStart;
                        while (j < i) {
                            if (!Util.containsElement(this.model.getPlusExonicStates(), states[j])) {
                                foundConflict = true;
                                break;
                            }
                            ++j;
                        }
                        if (actualExonStart == 0 ? false : Util.containsElement(this.model.getPlusExonicStates(), states[actualExonStart - 1]) || Util.containsElement(this.model.getPlusExonicStates(), states[i]) || foundConflict) {
                            int n = this.FN;
                            this.plusExonStats[n] = this.plusExonStats[n] + 1;
                        }
                    } else {
                        int j = actualExonStart;
                        while (j < i) {
                            if (!Util.containsElement(this.model.getMinusExonicStates(), states[j])) {
                                foundConflict = true;
                                break;
                            }
                            ++j;
                        }
                        if (actualExonStart == 0 ? false : Util.containsElement(this.model.getMinusExonicStates(), states[actualExonStart - 1]) || Util.containsElement(this.model.getMinusExonicStates(), states[i]) || foundConflict) {
                            int n = this.FN;
                            this.minusExonStats[n] = this.minusExonStats[n] + 1;
                        }
                    }
                }
            } else if (i == seq.length()) {
                boolean foundConflict = false;
                if (actualStrand == 1) {
                    int j = actualExonStart;
                    while (j < i + 1) {
                        if (!Util.containsElement(this.model.getPlusExonicStates(), states[j])) {
                            foundConflict = true;
                            break;
                        }
                        ++j;
                    }
                    if (actualExonStart == 0 ? false : Util.containsElement(this.model.getPlusExonicStates(), states[actualExonStart - 1]) || foundConflict) {
                        int n = this.FN;
                        this.plusExonStats[n] = this.plusExonStats[n] + 1;
                    }
                } else {
                    int j = actualExonStart;
                    while (j < i + 1) {
                        if (!Util.containsElement(this.model.getMinusExonicStates(), states[j])) {
                            foundConflict = true;
                            break;
                        }
                        ++j;
                    }
                    if (actualExonStart == 0 ? false : Util.containsElement(this.model.getMinusExonicStates(), states[actualExonStart - 1]) || foundConflict) {
                        int n = this.FN;
                        this.minusExonStats[n] = this.minusExonStats[n] + 1;
                    }
                }
            }
            if (Util.containsElement(this.model.getPlusIntronicStates(), state) && !readingPredictedIntron) {
                readingPredictedIntron = true;
                predictedIntronStart = i;
                predictedStrand = 1;
            }
            if (Util.containsElement(this.model.getMinusIntronicStates(), state) && !readingPredictedIntron) {
                readingPredictedIntron = true;
                predictedIntronStart = i;
                predictedStrand = -1;
            }
            if (!Util.containsElement(this.model.getPlusIntronicStates(), state) && !Util.containsElement(this.model.getMinusIntronicStates(), state)) {
                if (readingPredictedIntron) {
                    readingPredictedIntron = false;
                    boolean foundConflict = false;
                    if (predictedStrand == 1) {
                        int j = predictedIntronStart;
                        while (j < i) {
                            if (!Util.containsElement(this.model.getPlusIntronicStates(), seq.getY(j))) {
                                foundConflict = true;
                                break;
                            }
                            ++j;
                        }
                        if (!(Util.containsElement(this.model.getPlusIntronicStates(), seq.getY(predictedIntronStart - 1)) || Util.containsElement(this.model.getPlusIntronicStates(), seq.getY(i)) || foundConflict)) {
                            int n = this.TP;
                            this.plusIntronStats[n] = this.plusIntronStats[n] + 1;
                        } else {
                            int n = this.FP;
                            this.plusIntronStats[n] = this.plusIntronStats[n] + 1;
                        }
                    } else {
                        int j = predictedIntronStart;
                        while (j < i) {
                            if (!Util.containsElement(this.model.getMinusIntronicStates(), seq.getY(j))) {
                                foundConflict = true;
                                break;
                            }
                            ++j;
                        }
                        if (!(Util.containsElement(this.model.getMinusIntronicStates(), seq.getY(predictedIntronStart - 1)) || Util.containsElement(this.model.getMinusIntronicStates(), seq.getY(i)) || foundConflict)) {
                            int n = this.TP;
                            this.minusIntronStats[n] = this.minusIntronStats[n] + 1;
                        } else {
                            int n = this.FP;
                            this.minusIntronStats[n] = this.minusIntronStats[n] + 1;
                        }
                    }
                }
            } else if (i == seq.length()) {
                boolean foundConflict = false;
                if (predictedStrand == 1) {
                    int j = predictedIntronStart;
                    while (j < i + 1) {
                        if (!Util.containsElement(this.model.getPlusIntronicStates(), seq.getY(j))) {
                            foundConflict = true;
                            break;
                        }
                        ++j;
                    }
                    if (!Util.containsElement(this.model.getPlusIntronicStates(), seq.getY(predictedIntronStart - 1)) && !foundConflict) {
                        int n = this.TP;
                        this.plusIntronStats[n] = this.plusIntronStats[n] + 1;
                    } else {
                        int n = this.FP;
                        this.plusIntronStats[n] = this.plusIntronStats[n] + 1;
                    }
                } else {
                    int j = predictedIntronStart;
                    while (j < i + 1) {
                        if (!Util.containsElement(this.model.getMinusIntronicStates(), seq.getY(j))) {
                            foundConflict = true;
                            break;
                        }
                        ++j;
                    }
                    if (!Util.containsElement(this.model.getMinusIntronicStates(), seq.getY(predictedIntronStart - 1)) && !foundConflict) {
                        int n = this.TP;
                        this.minusIntronStats[n] = this.minusIntronStats[n] + 1;
                    } else {
                        int n = this.FP;
                        this.minusIntronStats[n] = this.minusIntronStats[n] + 1;
                    }
                }
            }
            if (Util.containsElement(this.model.getPlusIntronicStates(), stateY) && !readingActualIntron) {
                readingActualIntron = true;
                actualIntronStart = i;
                actualStrand = 1;
            }
            if (Util.containsElement(this.model.getMinusIntronicStates(), stateY) && !readingActualIntron) {
                readingActualIntron = true;
                actualIntronStart = i;
                actualStrand = -1;
            }
            if (!Util.containsElement(this.model.getPlusIntronicStates(), stateY) && !Util.containsElement(this.model.getMinusIntronicStates(), stateY)) {
                if (readingActualIntron) {
                    readingActualIntron = false;
                    boolean foundConflict = false;
                    if (actualStrand == 1) {
                        int j = actualIntronStart;
                        while (j < i) {
                            if (!Util.containsElement(this.model.getPlusIntronicStates(), states[j])) {
                                foundConflict = true;
                                break;
                            }
                            ++j;
                        }
                        if (Util.containsElement(this.model.getPlusIntronicStates(), states[actualIntronStart - 1]) || Util.containsElement(this.model.getPlusIntronicStates(), states[i]) || foundConflict) {
                            int n = this.FN;
                            this.plusIntronStats[n] = this.plusIntronStats[n] + 1;
                        }
                    } else {
                        int j = actualIntronStart;
                        while (j < i) {
                            if (!Util.containsElement(this.model.getMinusIntronicStates(), states[j])) {
                                foundConflict = true;
                                break;
                            }
                            ++j;
                        }
                        if (Util.containsElement(this.model.getMinusIntronicStates(), states[actualIntronStart - 1]) || Util.containsElement(this.model.getMinusIntronicStates(), states[i]) || foundConflict) {
                            int n = this.FN;
                            this.minusIntronStats[n] = this.minusIntronStats[n] + 1;
                        }
                    }
                }
            } else if (i == seq.length()) {
                boolean foundConflict = false;
                if (actualStrand == 1) {
                    int j = actualIntronStart;
                    while (j < i + 1) {
                        if (!Util.containsElement(this.model.getPlusIntronicStates(), states[j])) {
                            foundConflict = true;
                            break;
                        }
                        ++j;
                    }
                    if (Util.containsElement(this.model.getPlusIntronicStates(), states[actualIntronStart - 1]) || foundConflict) {
                        int n = this.FN;
                        this.plusIntronStats[n] = this.plusIntronStats[n] + 1;
                    }
                } else {
                    int j = actualIntronStart;
                    while (j < i + 1) {
                        if (!Util.containsElement(this.model.getMinusIntronicStates(), states[j])) {
                            foundConflict = true;
                            break;
                        }
                        ++j;
                    }
                    if (Util.containsElement(this.model.getMinusIntronicStates(), states[actualIntronStart - 1]) || foundConflict) {
                        int n = this.FN;
                        this.minusIntronStats[n] = this.minusIntronStats[n] + 1;
                    }
                }
            }
            ++i;
        }
        if (!foundMismatch) {
            ++this.perfectlyPredictedSequences;
        }
    }

    public String toString() {
        int[] codingNucleotidsStats = new int[]{this.plusExonStateStats[0] + this.minusExonStateStats[0], this.plusExonStateStats[1] + this.minusExonStateStats[1], this.plusExonStateStats[2] + this.minusExonStateStats[2], this.plusExonStateStats[3] + this.minusExonStateStats[3]};
        int[] exonStats = new int[]{this.plusExonStats[0] + this.minusExonStats[0], this.plusExonStats[1] + this.minusExonStats[1], this.plusExonStats[2] + this.minusExonStats[2], this.plusExonStats[3] + this.minusExonStats[3]};
        int[] intronStats = new int[]{this.plusIntronStats[0] + this.minusIntronStats[0], this.plusIntronStats[1] + this.minusIntronStats[1], this.plusIntronStats[2] + this.minusIntronStats[2], this.plusIntronStats[3] + this.minusIntronStats[3]};
        int[] intronStateStats = new int[]{this.plusIntronStateStats[0] + this.minusIntronStateStats[0], this.plusIntronStateStats[1] + this.minusIntronStateStats[1], this.plusIntronStateStats[2] + this.minusIntronStateStats[2], this.plusIntronStateStats[3] + this.minusIntronStateStats[3]};
        DecimalFormat format = new DecimalFormat("#.###");
        return "nucleotide matches:" + format.format((double)this.totalStateMatches / (double)this.totalLength * 100.0) + "%\n" + "perfectly predicted sequences:" + this.perfectlyPredictedSequences + "/" + this.totalSequences + "\n" + "---Exon statistics----\n" + "exon :" + Util.printStats2(exonStats) + "exon+ :" + Util.printStats2(this.plusExonStats) + "exon- :" + Util.printStats2(this.minusExonStats) + "---Intron statistics----\n" + "intron :" + Util.printStats2(intronStats) + "intron+ :" + Util.printStats2(this.plusIntronStats) + "intron- :" + Util.printStats2(this.minusIntronStats) + "---Matches against real annotation----\n" + "exon+ state matches:" + format.format((double)this.totalPlusExonStateMatches / (double)this.totalPlusExonLength * 100.0) + "%\n" + "exon- state matches:" + format.format((double)this.totalMinusExonStateMatches / (double)this.totalMinusExonLength * 100.0) + "%\n" + "---Matches against predicted annotation----\n" + "exon+ state matches:" + format.format((double)this.totalReversePlusExonStateMatches / (double)this.totalReversePlusExonLength * 100.0) + "%\n" + "exon- state matches:" + format.format((double)this.totalReverseMinusExonStateMatches / (double)this.totalReverseMinusExonLength * 100.0) + "%\n" + "---State statistics----\n" + "coding nucleotides:" + Util.printStats(codingNucleotidsStats) + "intron stats:" + Util.printStats(intronStateStats) + "intergenic stats:" + Util.printStats(this.intergenicStateStats) + "exon+ stats:" + Util.printStats(this.plusExonStateStats) + "exon- stats:" + Util.printStats(this.minusExonStateStats) + "intron+ stats:" + Util.printStats(this.plusIntronStateStats) + "intron- stats:" + Util.printStats(this.minusIntronStateStats);
    }

    public String toTabbedInfoString() {
        int[] codingNucleotidsStats = new int[]{this.plusExonStateStats[0] + this.minusExonStateStats[0], this.plusExonStateStats[1] + this.minusExonStateStats[1], this.plusExonStateStats[2] + this.minusExonStateStats[2], this.plusExonStateStats[3] + this.minusExonStateStats[3]};
        int[] exonStats = new int[]{this.plusExonStats[0] + this.minusExonStats[0], this.plusExonStats[1] + this.minusExonStats[1], this.plusExonStats[2] + this.minusExonStats[2], this.plusExonStats[3] + this.minusExonStats[3]};
        int[] intronStateStats = new int[]{this.plusIntronStateStats[0] + this.minusIntronStateStats[0], this.plusIntronStateStats[1] + this.minusIntronStateStats[1], this.plusIntronStateStats[2] + this.minusIntronStateStats[2], this.plusIntronStateStats[3] + this.minusIntronStateStats[3]};
        DecimalFormat format = new DecimalFormat("#.###");
        return "" + format.format((double)this.totalStateMatches / (double)this.totalLength * 100.0) + "%\t" + this.perfectlyPredictedSequences + "/" + this.totalSequences + "\t" + Util.printTabbedStats2(exonStats) + "\t" + Util.printTabbedStats3(codingNucleotidsStats) + "\t" + Util.printTabbedStats3(intronStateStats);
    }
}

