/*
 * Decompiled with CFR 0.152.
 */
package calhoun.analysis.crf;

import calhoun.analysis.crf.AbstractFeatureManager;
import calhoun.analysis.crf.CacheStrategySpec;
import calhoun.analysis.crf.FeatureList;
import calhoun.analysis.crf.FeatureManager;
import calhoun.analysis.crf.FeatureManagerEdge;
import calhoun.analysis.crf.FeatureManagerEdgeExplicitLength;
import calhoun.analysis.crf.FeatureManagerNode;
import calhoun.analysis.crf.FeatureManagerNodeExplicitLength;
import calhoun.analysis.crf.ModelManager;
import calhoun.analysis.crf.io.InputSequence;
import calhoun.analysis.crf.io.TrainingSequence;
import calhoun.util.Assert;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class CompositeFeatureManager
extends AbstractFeatureManager
implements FeatureManagerEdge,
FeatureManagerNode,
FeatureManagerEdgeExplicitLength,
FeatureManagerNodeExplicitLength {
    private static final long serialVersionUID = 5061912595256694049L;
    protected List<FeatureManager> allFeatureTypes = new ArrayList<FeatureManager>();
    protected List<FeatureManagerNode> nodeFeatureTypes = new ArrayList<FeatureManagerNode>();
    protected List<FeatureManagerEdge> edgeFeatureTypes = new ArrayList<FeatureManagerEdge>();
    protected List<FeatureManagerNodeExplicitLength> explicitLengthNodeFeatureTypes = new ArrayList<FeatureManagerNodeExplicitLength>();
    protected List<FeatureManagerEdgeExplicitLength> explicitLengthEdgeFeatureTypes = new ArrayList<FeatureManagerEdgeExplicitLength>();
    int[] startIndexes = null;
    int startIx;
    int totalFeatures;

    public List<FeatureManager> getComponentFeatures() {
        return this.allFeatureTypes;
    }

    public void setComponentFeatures(List<FeatureManager> components) {
        for (FeatureManager component : components) {
            this.addFeatureManager(component);
        }
    }

    public void addFeatureManager(FeatureManager fm) {
        this.addFeatureManager(null, null, fm);
    }

    public void addFeatureManager(String name, String inputParams, FeatureManager fm) {
        Assert.a(this.startIndexes == null, "Attempted to add a new FeatureManager after training.");
        if (name != null) {
            fm.setInputComponent(name);
        }
        this.allFeatureTypes.add(fm);
        if (fm instanceof FeatureManagerNode) {
            this.nodeFeatureTypes.add((FeatureManagerNode)fm);
        }
        if (fm instanceof FeatureManagerEdge) {
            this.edgeFeatureTypes.add((FeatureManagerEdge)fm);
        }
        if (fm instanceof FeatureManagerNodeExplicitLength) {
            this.explicitLengthNodeFeatureTypes.add((FeatureManagerNodeExplicitLength)fm);
        }
        if (fm instanceof FeatureManagerEdgeExplicitLength) {
            this.explicitLengthEdgeFeatureTypes.add((FeatureManagerEdgeExplicitLength)fm);
        }
    }

    @Override
    public int getNumFeatures() {
        Assert.a(this.startIndexes != null, "Attempted to get number of features before training.");
        return this.totalFeatures;
    }

    @Override
    public String getFeatureName(int featureIndex) {
        int index = Arrays.binarySearch(this.startIndexes, featureIndex);
        if (index < 0) {
            index = -index - 2;
        }
        while (this.allFeatureTypes.get(index).getNumFeatures() == 0) {
            ++index;
        }
        return this.allFeatureTypes.get(index).getFeatureName(featureIndex);
    }

    public int getFeatureOffset(int featureIndex) {
        int index = Arrays.binarySearch(this.startIndexes, featureIndex);
        if (index < 0) {
            index = -index - 2;
        }
        while (this.allFeatureTypes.get(index).getNumFeatures() == 0) {
            ++index;
        }
        return this.startIndexes[index];
    }

    @Override
    public void train(int startingIndex, ModelManager modelInfo, List data) {
        Assert.a(this.allFeatureTypes.size() > 0, "No features types have been assigned.");
        Assert.a(this.startIndexes == null, "FeatureManager has already been trained.");
        this.startIx = startingIndex;
        this.startIndexes = new int[this.allFeatureTypes.size()];
        this.totalFeatures = 0;
        for (int i = 0; i < this.startIndexes.length; ++i) {
            this.startIndexes[i] = this.totalFeatures + this.startIx;
            FeatureManager fm = this.allFeatureTypes.get(i);
            List compData = fm.getInputComponent() == null ? data : new ComponentList(data, fm.getInputComponent());
            fm.train(this.totalFeatures, modelInfo, compData);
            this.totalFeatures += fm.getNumFeatures();
        }
    }

    public void evaluateNode(InputSequence seq, int pos, int state, FeatureList result) {
        for (FeatureManagerNode fm : this.nodeFeatureTypes) {
            InputSequence<?> componentSeq = fm.getInputComponent() == null ? seq : seq.getComponent(fm.getInputComponent());
            fm.evaluateNode(componentSeq, pos, state, result);
            if (result.isValid()) continue;
            break;
        }
    }

    public void evaluateEdge(InputSequence seq, int pos, int prevState, int state, FeatureList result) {
        for (FeatureManagerEdge fm : this.edgeFeatureTypes) {
            InputSequence<?> componentSeq = fm.getInputComponent() == null ? seq : seq.getComponent(fm.getInputComponent());
            fm.evaluateEdge(componentSeq, pos, prevState, state, result);
            if (result.isValid()) continue;
            break;
        }
    }

    public void evaluateNodeLength(InputSequence seq, int pos, int length, int state, FeatureList result) {
        Assert.a(length > 0);
        for (FeatureManagerNodeExplicitLength fm : this.explicitLengthNodeFeatureTypes) {
            InputSequence<?> componentSeq = fm.getInputComponent() == null ? seq : seq.getComponent(fm.getInputComponent());
            fm.evaluateNodeLength(componentSeq, pos, length, state, result);
            if (result.isValid()) continue;
            break;
        }
    }

    public void evaluateEdgeLength(InputSequence seq, int pos, int length, int prevState, int state, FeatureList result) {
        Assert.a(length > 0);
        for (FeatureManagerEdgeExplicitLength fm : this.explicitLengthEdgeFeatureTypes) {
            InputSequence<?> componentSeq = fm.getInputComponent() == null ? seq : seq.getComponent(fm.getInputComponent());
            fm.evaluateEdgeLength(componentSeq, pos, length, prevState, state, result);
            if (result.isValid()) continue;
            break;
        }
    }

    @Override
    public CacheStrategySpec getCacheStrategy() {
        return new CacheStrategySpec(CacheStrategySpec.CacheStrategy.COMPOSITE);
    }

    protected static class ComponentList
    extends ArrayList<InputSequence<?>> {
        private static final long serialVersionUID = 2954775229926328434L;
        String name;

        public ComponentList(List<TrainingSequence<?>> start, String name) {
            super(start);
            this.name = name;
        }

        @Override
        public InputSequence<?> get(int i) {
            return this.transform((TrainingSequence)super.get(i));
        }

        public InputSequence<?> transform(TrainingSequence<?> in) {
            return in.getComponent(this.name);
        }
    }
}

