/*
 * Decompiled with CFR 0.152.
 */
package calhoun.analysis.crf.executables.viewer;

import calhoun.analysis.crf.CRFInference;
import calhoun.analysis.crf.Conrad;
import calhoun.analysis.crf.io.TrainingSequence;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;

public class ViterbiTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 4315252264878822897L;
    Conrad crfModel;
    TrainingSequence seq;
    int[] viterbiPath;
    double[] bestScore;
    int nStates;

    public ViterbiTableModel(Conrad crfModel, TrainingSequence seq) {
        this.crfModel = crfModel;
        this.seq = seq;
        this.nStates = crfModel.getModel().getNumStates();
        CRFInference.InferenceResult result = crfModel.predict(seq);
        this.viterbiPath = result.hiddenStates;
        this.bestScore = null;
    }

    @Override
    public String getColumnName(int col) {
        return col == 0 ? "Position" : "    " + Integer.toString(col) + "    ";
    }

    @Override
    public int getRowCount() {
        return this.crfModel.getModel().getNumStates() + 2;
    }

    @Override
    public int getColumnCount() {
        return this.seq.length() + 1;
    }

    public Class getColumnClass(int col) {
        return String.class;
    }

    @Override
    public Object getValueAt(int row, int col) {
        switch (row) {
            case 0: {
                return col == 0 ? "Input" : this.seq.getInputSequence().getX(col - 1).toString();
            }
            case 1: {
                return col == 0 ? "Label" : Integer.toString(this.seq.getY(col - 1));
            }
        }
        return col == 0 ? this.crfModel.getModel().getStateName(row - 2) : Double.toString(this.bestScore[(row - 2) * this.nStates + col - 1]);
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return false;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
    }

    public class ViterbiCellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = -1156070614840797662L;

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (row > 1 && column > 0 && row - 2 == ViterbiTableModel.this.viterbiPath[column - 1]) {
                this.setBackground(Color.RED);
            } else {
                this.setBackground(Color.WHITE);
            }
            return this;
        }
    }
}

