/*
 * Decompiled with CFR 0.152.
 */
package calhoun.analysis.crf.features.generic;

import calhoun.analysis.crf.AbstractFeatureManager;
import calhoun.analysis.crf.FeatureList;
import calhoun.analysis.crf.FeatureManagerNode;
import calhoun.analysis.crf.ModelManager;
import calhoun.analysis.crf.io.InputSequence;
import calhoun.util.Assert;
import java.util.Arrays;
import java.util.List;

public class StartFeatures
extends AbstractFeatureManager<Object>
implements FeatureManagerNode<Object> {
    private static final long serialVersionUID = 2578820778300251051L;
    int startIx;
    int[] startStates;
    String[] names;
    int[] configStates = new int[]{0, 1};

    public void setStates(int[] config) {
        this.configStates = config;
    }

    @Override
    public String getFeatureName(int featureIndex) {
        int raw = featureIndex - this.startIx;
        Assert.a(raw >= 0 && raw < this.names.length, "Invalid feature index");
        return this.names[raw];
    }

    @Override
    public int getNumFeatures() {
        return this.names.length;
    }

    @Override
    public void evaluateNode(InputSequence<?> seq, int pos, int state, FeatureList result) {
        int index;
        if (pos == 0 && (index = this.startStates[state]) != -1) {
            result.addFeature(index, 1.0);
        }
    }

    @Override
    public void train(int startingIndex, ModelManager modelInfo, List data) {
        this.startIx = startingIndex;
        this.startStates = new int[modelInfo.getNumStates()];
        Arrays.fill(this.startStates, -1);
        this.names = new String[this.configStates.length];
        for (int i = 0; i < this.configStates.length; ++i) {
            this.startStates[this.configStates[i]] = this.startIx + i;
            this.names[i] = "Start." + modelInfo.getStateName(this.configStates[i]);
        }
    }
}

