/*
 * Decompiled with CFR 0.152.
 */
package calhoun.analysis.crf.features.generic;

import calhoun.analysis.crf.AbstractFeatureManager;
import calhoun.analysis.crf.CacheStrategySpec;
import calhoun.analysis.crf.FeatureList;
import calhoun.analysis.crf.FeatureManagerEdge;
import calhoun.analysis.crf.ModelManager;
import calhoun.analysis.crf.io.InputSequence;
import calhoun.analysis.crf.io.TrainingSequence;
import calhoun.util.Assert;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WeightedEdges
extends AbstractFeatureManager<Object>
implements FeatureManagerEdge<Object> {
    private static final long serialVersionUID = 8477631359065280630L;
    private static final Log log = LogFactory.getLog(WeightedEdges.class);
    int startIx;
    ModelManager manager;
    float[][] transitions;

    @Override
    public CacheStrategySpec getCacheStrategy() {
        return new CacheStrategySpec(CacheStrategySpec.CacheStrategy.CONSTANT);
    }

    @Override
    public String getFeatureName(int featureIndex) {
        Assert.a(featureIndex == this.startIx, "Invalid feature index: ", featureIndex, ". Must be ", this.startIx);
        return "WeightedEdges";
    }

    @Override
    public int getNumFeatures() {
        return 1;
    }

    @Override
    public void evaluateEdge(InputSequence<?> seq, int pos, int prevState, int state, FeatureList result) {
        result.addFeature(this.startIx, this.transitions[prevState][state]);
    }

    @Override
    public void train(int startingIndex, ModelManager modelInfo, List<? extends TrainingSequence<?>> data) {
        log.debug((Object)"Training edges");
        this.startIx = startingIndex;
        this.manager = modelInfo;
        int nStates = this.manager.getNumStates();
        this.transitions = new float[nStates][nStates];
        for (int j = 0; j < nStates; ++j) {
            for (int k = 0; k < nStates; ++k) {
                this.transitions[j][k] = 1.0f;
            }
        }
        for (TrainingSequence<?> seq : data) {
            for (int pos = 1; pos < seq.length(); ++pos) {
                int start = seq.getY(pos - 1);
                int end = seq.getY(pos);
                float[] fArray = this.transitions[start];
                int n = end;
                fArray[n] = fArray[n] + 1.0f;
            }
        }
        log.debug((Object)"The transition logprobabilities are as follows (row is the FROM state and column is the TO state");
        for (int j = 0; j < nStates; ++j) {
            int k;
            String s = modelInfo.getStateName(j);
            float rowtotal = 0.0f;
            for (k = 0; k < nStates; ++k) {
                rowtotal += this.transitions[j][k];
            }
            for (k = 0; k < nStates; ++k) {
                this.transitions[j][k] = (float)Math.log(this.transitions[j][k] / rowtotal);
                s = s + "\t" + this.transitions[j][k];
            }
            log.debug((Object)s);
        }
    }
}

