/*
 * Decompiled with CFR 0.152.
 */
package calhoun.analysis.crf.features.interval13;

import calhoun.analysis.crf.AbstractFeatureManager;
import calhoun.analysis.crf.CacheStrategySpec;
import calhoun.analysis.crf.FeatureList;
import calhoun.analysis.crf.FeatureManagerNode;
import calhoun.analysis.crf.ModelManager;
import calhoun.analysis.crf.io.CompositeInput;
import calhoun.analysis.crf.io.InputSequence;
import calhoun.analysis.crf.io.TrainingSequence;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BlastInterval13
extends AbstractFeatureManager<CompositeInput>
implements FeatureManagerNode<CompositeInput> {
    private static final long serialVersionUID = -7659288739348604129L;
    private static final Log log = LogFactory.getLog(BlastInterval13.class);
    boolean debug = log.isDebugEnabled();
    int startIx;
    ModelManager model;
    boolean[] intergenicState;
    boolean[] plusExonState;
    boolean[] minusExonState;
    boolean[] plusIntronState;
    boolean[] minusIntronState;

    @Override
    public int getNumFeatures() {
        return 3;
    }

    @Override
    public String getFeatureName(int featureIndex) {
        String[] types = new String[]{"exon", "intron", "Intergenic", "a"};
        return "Blast " + types[featureIndex - this.startIx];
    }

    @Override
    public void evaluateNode(InputSequence<? extends CompositeInput> seq, int pos, int state, FeatureList result) {
        if (pos == seq.length() - 1) {
            return;
        }
        InputSequence<?> pblast = seq.getComponent("pblast");
        InputSequence<?> mblast = seq.getComponent("mblast");
        int plusEst = (Integer)pblast.getX(pos + 1);
        int minusEst = (Integer)mblast.getX(pos + 1);
        if (this.plusExonState[state] && plusEst == 1 || this.minusExonState[state] && minusEst == 1) {
            result.addFeature(this.startIx, 1.0);
        }
        if (this.plusIntronState[state] && plusEst == 1 || this.minusIntronState[state] && minusEst == 1) {
            result.addFeature(this.startIx + 1, 1.0);
        }
        if (this.intergenicState[state] && (plusEst == 1 || minusEst == 1)) {
            result.addFeature(this.startIx + 2, 1.0);
        }
    }

    @Override
    public void train(int startingIndex, ModelManager modelInfo, List<? extends TrainingSequence<? extends CompositeInput>> data) {
        this.startIx = startingIndex;
        this.model = modelInfo;
        int nStates = this.model.getNumStates();
        this.plusExonState = new boolean[nStates];
        this.plusExonState[this.model.getStateIndex((String)"exon0")] = true;
        this.plusExonState[this.model.getStateIndex((String)"exon1")] = true;
        this.plusExonState[this.model.getStateIndex((String)"exon2")] = true;
        this.minusExonState = new boolean[nStates];
        this.minusExonState[this.model.getStateIndex((String)"exon0m")] = true;
        this.minusExonState[this.model.getStateIndex((String)"exon1m")] = true;
        this.minusExonState[this.model.getStateIndex((String)"exon2m")] = true;
        this.plusIntronState = new boolean[nStates];
        this.plusIntronState[this.model.getStateIndex((String)"intron0")] = true;
        this.plusIntronState[this.model.getStateIndex((String)"intron1")] = true;
        this.plusIntronState[this.model.getStateIndex((String)"intron2")] = true;
        this.minusIntronState = new boolean[nStates];
        this.minusIntronState[this.model.getStateIndex((String)"intron0m")] = true;
        this.minusIntronState[this.model.getStateIndex((String)"intron1m")] = true;
        this.minusIntronState[this.model.getStateIndex((String)"intron2m")] = true;
        this.intergenicState = new boolean[nStates];
        this.intergenicState[this.model.getStateIndex((String)"intergenic")] = true;
    }

    @Override
    public CacheStrategySpec getCacheStrategy() {
        return new CacheStrategySpec(CacheStrategySpec.CacheStrategy.DENSE);
    }
}

