/*
 * Decompiled with CFR 0.152.
 */
package calhoun.analysis.crf.features.interval29;

import calhoun.analysis.crf.CacheStrategySpec;
import calhoun.analysis.crf.FeatureList;
import calhoun.analysis.crf.FeatureManagerNodeExplicitLength;
import calhoun.analysis.crf.ModelManager;
import calhoun.analysis.crf.io.InputSequence;
import calhoun.analysis.crf.io.SequenceConverter;
import calhoun.analysis.crf.io.TrainingSequence;
import calhoun.analysis.crf.statistics.MixtureOfGammas;
import calhoun.util.Assert;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StateLengthLogprobInterval29
implements FeatureManagerNodeExplicitLength<Character> {
    private static final long serialVersionUID = 8685543199212865835L;
    private static final Log log = LogFactory.getLog(StateLengthLogprobInterval29.class);
    private int startIx;
    ModelManager mi;
    private String inputComponentName;
    MixtureOfGammas intergenicMixGamma;
    MixtureOfGammas exonMixGamma;
    MixtureOfGammas intronMixGamma;
    private boolean forceExponential = false;
    private boolean exonExponential = false;
    private boolean multipleFeatures = true;

    public void setForceExponential(boolean forceExponential) {
        this.forceExponential = forceExponential;
    }

    public void setExonExponential(boolean exonExponential) {
        this.exonExponential = exonExponential;
    }

    @Override
    public void evaluateNodeLength(InputSequence<? extends Character> seq, int pos, int length, int state, FeatureList result) {
        double val;
        Assert.a(length > 0);
        MixtureOfGammas mg = null;
        int indexOffset = Integer.MIN_VALUE;
        switch (state) {
            case 0: {
                indexOffset = 0;
                mg = this.intergenicMixGamma;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: 
            case 8: 
            case 9: {
                indexOffset = 1;
                mg = this.exonMixGamma;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 11: 
            case 12: {
                indexOffset = 2;
                mg = this.intronMixGamma;
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                indexOffset = 3;
                break;
            }
            default: {
                Assert.a(false);
            }
        }
        if (mg != null) {
            val = mg.logEvaluate(length);
        } else {
            Assert.a(state >= 13 && state <= 28, "Trying to use exact state lengths for non-boundary state.");
            val = length == 2 ? -0.5 : -200.0;
        }
        Assert.a(val != Double.NEGATIVE_INFINITY && val != Double.POSITIVE_INFINITY && !Double.isNaN(val));
        if (val > 0.0) {
            log.warn((Object)"About to return a state length logprob evaluation that is greater than zero, see notes in source code.");
        }
        result.addFeature(this.startIx + (this.multipleFeatures ? indexOffset : 0), val);
    }

    @Override
    public CacheStrategySpec getCacheStrategy() {
        return new CacheStrategySpec(CacheStrategySpec.CacheStrategy.LENGTHFUNCTION);
    }

    @Override
    public String getFeatureName(int featureIndex) {
        if (this.multipleFeatures) {
            String type = "";
            switch (featureIndex - this.startIx) {
                case 0: {
                    type = "intergenic";
                    break;
                }
                case 1: {
                    type = "exon";
                    break;
                }
                case 2: {
                    type = "intron";
                    break;
                }
                case 3: {
                    type = "boundary";
                }
            }
            return "StateDurationLogProbForModelInterval21 " + type;
        }
        return "StateDurationLogProbForModelInterval21";
    }

    @Override
    public String getInputComponent() {
        return this.inputComponentName;
    }

    @Override
    public void setInputComponent(String name) {
        this.inputComponentName = name;
    }

    @Override
    public void train(int startingIndex, ModelManager modelInfo, List<? extends TrainingSequence<? extends Character>> data) {
        this.startIx = startingIndex;
        this.mi = modelInfo;
        Assert.a(this.mi.getNumStates() == 29);
        ArrayList<ArrayList<Integer>> stateDurations = SequenceConverter.stateVector2StateLengths(data, this.mi.getNumStates());
        ArrayList exonLengths = new ArrayList();
        ArrayList intronLengths = new ArrayList();
        ArrayList intergenicLengths = new ArrayList();
        intergenicLengths.addAll(stateDurations.get(0));
        exonLengths.addAll(stateDurations.get(1));
        exonLengths.addAll(stateDurations.get(2));
        exonLengths.addAll(stateDurations.get(3));
        exonLengths.addAll(stateDurations.get(7));
        exonLengths.addAll(stateDurations.get(8));
        exonLengths.addAll(stateDurations.get(9));
        intronLengths.addAll(stateDurations.get(4));
        intronLengths.addAll(stateDurations.get(5));
        intronLengths.addAll(stateDurations.get(6));
        intronLengths.addAll(stateDurations.get(10));
        intronLengths.addAll(stateDurations.get(11));
        intronLengths.addAll(stateDurations.get(12));
        double[] inter = new double[intergenicLengths.size()];
        for (int j = 0; j < intergenicLengths.size(); ++j) {
            inter[j] = ((Integer)intergenicLengths.get(j)).intValue();
        }
        double[] exon = new double[exonLengths.size()];
        for (int j = 0; j < exonLengths.size(); ++j) {
            exon[j] = ((Integer)exonLengths.get(j)).intValue();
        }
        double[] intron = new double[intronLengths.size()];
        for (int j = 0; j < intronLengths.size(); ++j) {
            intron[j] = ((Integer)intronLengths.get(j)).intValue();
        }
        if (this.forceExponential) {
            this.intergenicMixGamma = new MixtureOfGammas(inter, true);
            this.exonMixGamma = new MixtureOfGammas(exon, true);
            this.intronMixGamma = new MixtureOfGammas(intron, true);
        } else if (this.exonExponential) {
            this.intergenicMixGamma = new MixtureOfGammas(inter, true);
            this.exonMixGamma = new MixtureOfGammas(exon, true);
            this.intronMixGamma = new MixtureOfGammas(intron);
        } else {
            this.intergenicMixGamma = new MixtureOfGammas(inter, true);
            this.exonMixGamma = new MixtureOfGammas(exon);
            this.intronMixGamma = new MixtureOfGammas(intron);
        }
    }

    @Override
    public int getNumFeatures() {
        return this.multipleFeatures ? 4 : 1;
    }

    public boolean isMultipleFeatures() {
        return this.multipleFeatures;
    }

    public void setMultipleFeatures(boolean multipleFeatures) {
        this.multipleFeatures = multipleFeatures;
    }
}

