/*
 * Decompiled with CFR 0.152.
 */
package calhoun.analysis.crf.features.supporting;

import calhoun.analysis.crf.io.InputSequence;
import calhoun.seq.KmerHasher;
import calhoun.util.Assert;
import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LogProbLookup
implements Serializable {
    private static final long serialVersionUID = -9195647924401633963L;
    private static final Log log = LogFactory.getLog(LogProbLookup.class);
    final KmerHasher.CharacterHash hashForward = KmerHasher.ACGTother;
    final KmerHasher.CharacterHash hashReverse = KmerHasher.ACGTotherRC;
    boolean finalized;
    final int mult = 4;
    int maxLookBack;
    double[] lookupTable;
    int lookupTableSize;

    public LogProbLookup(int lookBack, double pseudoCount) {
        int i;
        Assert.a(lookBack >= 0);
        Assert.a(lookBack < 10);
        this.maxLookBack = lookBack;
        this.finalized = false;
        this.lookupTableSize = 1;
        for (i = 0; i <= lookBack; ++i) {
            this.lookupTableSize *= 4;
        }
        this.lookupTable = new double[this.lookupTableSize];
        for (i = 0; i < this.lookupTableSize; ++i) {
            this.lookupTable[i] = pseudoCount;
        }
    }

    private boolean isHistory(InputSequence<? extends Character> seq, int pos) {
        for (int j = pos - this.maxLookBack; j <= pos + this.maxLookBack; ++j) {
            if (this.hashForward.hash(seq.getX(j).charValue()) != 4) continue;
            return false;
        }
        return true;
    }

    private int getInd(InputSequence<? extends Character> seq, int pos, boolean isPlus) {
        int ind = 0;
        if (isPlus) {
            if (pos < this.maxLookBack) {
                return -1;
            }
            for (int j = pos - this.maxLookBack; j <= pos; ++j) {
                int h = this.hashForward.hash(seq.getX(j).charValue());
                if (h < 4) {
                    ind *= 4;
                    ind += h;
                    continue;
                }
                return -1;
            }
        } else {
            if (pos + this.maxLookBack >= seq.length()) {
                return -1;
            }
            for (int j = pos + this.maxLookBack; j >= pos; --j) {
                int h = this.hashReverse.hash(seq.getX(j).charValue());
                if (h < 4) {
                    ind *= 4;
                    ind += h;
                    continue;
                }
                return -1;
            }
        }
        return ind;
    }

    public void increment(InputSequence<? extends Character> seq, int pos, boolean isPlus) {
        Assert.a(!this.finalized);
        int ind = this.getInd(seq, pos, isPlus);
        if (ind >= 0) {
            int n = ind;
            this.lookupTable[n] = this.lookupTable[n] + 1.0;
        }
    }

    public void finalize() {
        Assert.a(!this.finalized);
        log.debug((Object)("finalizing a LogProbLookup, lookupTablesize=" + this.lookupTableSize + "    mult=" + 4));
        for (int i = 0; i < this.lookupTableSize / 4; ++i) {
            int j;
            double sum = 0.0;
            for (j = 4 * i; j < 4 * (i + 1); ++j) {
                sum += this.lookupTable[j];
            }
            for (j = 4 * i; j < 4 * (i + 1); ++j) {
                this.lookupTable[j] = Math.log(this.lookupTable[j] / sum);
            }
        }
        this.finalized = true;
    }

    public double lookup(InputSequence<? extends Character> seq, int pos, boolean isPlus) {
        Assert.a(this.finalized);
        int ind = this.getInd(seq, pos, isPlus);
        if (ind >= 0) {
            return this.lookupTable[ind];
        }
        return 0.0;
    }
}

