/*
 * Decompiled with CFR 0.152.
 */
package calhoun.analysis.crf.features.supporting.phylogenetic;

import calhoun.analysis.crf.ModelManager;
import calhoun.analysis.crf.features.supporting.phylogenetic.EvolutionaryModel;
import calhoun.analysis.crf.features.supporting.phylogenetic.HKY85Model;
import calhoun.analysis.crf.features.supporting.phylogenetic.Kimura80Model;
import calhoun.analysis.crf.features.supporting.phylogenetic.PhylogeneticTreeFelsensteinOrder;
import calhoun.analysis.crf.io.InputSequence;
import calhoun.analysis.crf.io.MultipleAlignmentInputSequence;
import calhoun.analysis.crf.io.TrainingSequence;
import calhoun.seq.KmerHasher;
import calhoun.util.Assert;
import flanagan.math.Minimisation;
import flanagan.math.MinimisationFunction;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ColumnConditionalLogProbability
implements Serializable {
    private static final long serialVersionUID = 5837909206967310115L;
    private static final Log log = LogFactory.getLog(ColumnConditionalLogProbability.class);
    InputSequence<MultipleAlignmentInputSequence.MultipleAlignmentColumn> lastSeq;
    int lastPos;
    double[] vals;
    List<int[]> clusters;
    int[] state2cluster;
    List<EvolutionaryModel> emodels;
    private ModelManager model;
    static KmerHasher h = new KmerHasher(KmerHasher.ACGTother, 1);
    Map<Integer, double[]> columnCache = new HashMap<Integer, double[]>();
    private int eModelNum;

    public ColumnConditionalLogProbability(List<int[]> clusters, int eModelNum) {
        this.clusters = clusters;
        this.eModelNum = eModelNum;
    }

    public int numClusters() {
        return this.clusters.size();
    }

    public int state2cluster(int state) {
        return this.state2cluster[state];
    }

    public double condLogProb(InputSequence<? extends MultipleAlignmentInputSequence.MultipleAlignmentColumn> seq, int pos, int state) {
        Assert.a(state < this.model.getNumStates());
        MultipleAlignmentInputSequence.MultipleAlignmentColumn col = seq.getX(pos);
        return this.emodels.get(this.state2cluster[state]).logprob(col, true);
    }

    public void train(ModelManager modelInfo, final List<? extends TrainingSequence<? extends MultipleAlignmentInputSequence.MultipleAlignmentColumn>> data) {
        int j;
        int i;
        this.model = modelInfo;
        this.vals = new double[this.clusters.size()];
        final PhylogeneticTreeFelsensteinOrder felsOrder = data.get(0).getX(0).getMultipleAlignment().getFelsensteinOrder();
        int nStates = this.model.getNumStates();
        this.state2cluster = new int[nStates];
        for (i = 0; i < nStates; ++i) {
            this.state2cluster[i] = -1;
        }
        for (j = 0; j < this.clusters.size(); ++j) {
            int[] C = this.clusters.get(j);
            for (int k = 0; k < C.length; ++k) {
                this.state2cluster[C[k]] = j;
            }
        }
        for (i = 0; i < nStates; ++i) {
            Assert.a(this.state2cluster[i] >= 0);
        }
        this.emodels = new ArrayList<EvolutionaryModel>();
        for (j = 0; j < this.clusters.size(); ++j) {
            double[] eresults;
            double[] results;
            double[] steps;
            double[] starts;
            int nParm;
            int maxIter;
            final int cluster = j;
            for (int k = 0; k < this.clusters.get(j).length; ++k) {
                log.debug((Object)("Training evolutionary model for:  " + this.model.getStateName(this.clusters.get(j)[k])));
            }
            final double[] pi = new double[]{1.0, 1.0, 1.0, 1.0};
            for (TrainingSequence<? extends MultipleAlignmentInputSequence.MultipleAlignmentColumn> trainingSequence : data) {
                int len = trainingSequence.length();
                for (int ix = 0; ix < len; ++ix) {
                    int x;
                    int y = trainingSequence.getY(ix);
                    if (this.state2cluster[y] != cluster || (x = h.hash(trainingSequence.getX(ix).nucleotide(0))) >= 4) continue;
                    int n = x;
                    pi[n] = pi[n] + 1.0;
                }
            }
            double total = pi[0] + pi[1] + pi[2] + pi[3];
            pi[0] = pi[0] / total;
            pi[1] = pi[1] / total;
            pi[2] = pi[2] / total;
            pi[3] = pi[3] / total;
            if (this.eModelNum == 0) {
                MinimisationFunction mFunc = new MinimisationFunction(){

                    @Override
                    public double function(double[] d) {
                        double[] ed = new double[]{Math.exp(d[0]), Math.exp(d[1])};
                        Kimura80Model R = new Kimura80Model(ed);
                        EvolutionaryModel M = new EvolutionaryModel(felsOrder, pi, R);
                        double ret = 0.0;
                        for (TrainingSequence aln : data) {
                            int len = aln.length();
                            for (int ix = 0; ix < len; ++ix) {
                                int y = aln.getY(ix);
                                if (ColumnConditionalLogProbability.this.state2cluster[y] != cluster) continue;
                                ret += M.logprob((MultipleAlignmentInputSequence.MultipleAlignmentColumn)aln.getX(ix), false);
                            }
                        }
                        return -ret;
                    }
                };
                maxIter = 50;
                nParm = 2;
                Minimisation m = new Minimisation();
                m.setNmax(maxIter);
                starts = new double[2];
                Arrays.fill(starts, 0.1);
                steps = new double[2];
                Arrays.fill(steps, 0.1);
                m.nelderMead(mFunc, starts, steps);
                if (!m.getConvStatus()) {
                    log.warn((Object)"WARNING - Nelder-Mead routine says convergence was not reached");
                }
                results = m.getParamValues();
                eresults = new double[]{Math.exp(results[0]), Math.exp(results[1])};
                this.emodels.add(new EvolutionaryModel(felsOrder, pi, new Kimura80Model(eresults)));
                this.emodels.get(cluster).summarize();
                continue;
            }
            if (this.eModelNum == 1) {
                MinimisationFunction mFunc = new MinimisationFunction(){

                    @Override
                    public double function(double[] d) {
                        double[] ed = new double[]{Math.exp(d[0]), Math.exp(d[1]), pi[0], pi[1], pi[2]};
                        HKY85Model R = new HKY85Model(ed);
                        EvolutionaryModel M = new EvolutionaryModel(felsOrder, pi, R);
                        double ret = 0.0;
                        for (TrainingSequence aln : data) {
                            int len = aln.length();
                            for (int ix = 0; ix < len; ++ix) {
                                int y = aln.getY(ix);
                                if (ColumnConditionalLogProbability.this.state2cluster[y] != cluster) continue;
                                ret += M.logprob((MultipleAlignmentInputSequence.MultipleAlignmentColumn)aln.getX(ix), false);
                            }
                        }
                        return -ret;
                    }
                };
                maxIter = 50;
                nParm = 2;
                Minimisation m = new Minimisation();
                m.setNmax(maxIter);
                starts = new double[2];
                Arrays.fill(starts, 0.1);
                steps = new double[2];
                Arrays.fill(steps, 0.1);
                m.nelderMead(mFunc, starts, steps);
                if (!m.getConvStatus()) {
                    log.warn((Object)"WARNING - Nelder-Mead routine says convergence was not reached");
                }
                results = m.getParamValues();
                eresults = new double[]{Math.exp(results[0]), Math.exp(results[1]), pi[0], pi[1], pi[2]};
                this.emodels.add(new EvolutionaryModel(felsOrder, pi, new HKY85Model(eresults)));
                this.emodels.get(cluster).summarize();
                continue;
            }
            Assert.a(false);
        }
        Assert.a(this.emodels.size() == this.clusters.size());
        log.debug((Object)"Just trained the Felsenstein Features");
    }
}

