/*
 * Decompiled with CFR 0.152.
 */
package calhoun.analysis.crf.features.supporting.phylogenetic;

import calhoun.analysis.crf.features.supporting.phylogenetic.NucleotideSubstitutionModel;
import calhoun.util.Assert;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HKY85Model
extends NucleotideSubstitutionModel {
    private static final long serialVersionUID = -1555350959092722736L;
    private static final Log log = LogFactory.getLog(HKY85Model.class);
    double ts;
    double tv;
    double piA;
    double piC;
    double piG;
    double piT;

    public HKY85Model(double[] parms) {
        this.setParameters(parms);
    }

    public HKY85Model() {
        this.ts = 0.6;
        this.tv = 0.2;
        this.piA = 0.25;
        this.piC = 0.25;
        this.piG = 0.25;
        this.piT = 0.25;
    }

    @Override
    public String getEvolutionaryModelName() {
        return "HKY85_nucleotide_evolution_model";
    }

    @Override
    public double[] getParameters() {
        double[] ret = new double[]{this.ts, this.tv, this.piA, this.piC, this.piG, this.piT};
        return ret;
    }

    @Override
    public void setParameters(double[] parms) {
        Assert.a(parms.length == 5);
        for (int j = 0; j < 5; ++j) {
            Assert.a(parms[j] > 0.0);
        }
        this.ts = parms[0];
        this.tv = parms[1];
        this.piA = parms[2];
        this.piC = parms[3];
        this.piG = parms[4];
        this.piT = 1.0 - this.piA - this.piC - this.piG;
        Assert.a(this.piT > 0.0);
        double[][] X = new double[4][4];
        int A = 0;
        int C = 1;
        int G = 2;
        int T = 3;
        X[A][A] = 0.0;
        X[A][C] = this.tv * this.piC;
        X[A][G] = this.ts * this.piG;
        X[A][T] = this.tv * this.piT;
        X[C][A] = this.tv * this.piA;
        X[C][C] = 0.0;
        X[C][G] = this.tv * this.piG;
        X[C][T] = this.ts * this.piT;
        X[G][A] = this.ts * this.piA;
        X[G][C] = this.tv * this.piC;
        X[G][G] = 0.0;
        X[G][T] = this.tv * this.piT;
        X[T][A] = this.tv * this.piA;
        X[T][C] = this.ts * this.piC;
        X[T][G] = this.tv * this.piG;
        X[T][T] = 0.0;
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                if (j == i) continue;
                double[] dArray = X[i];
                int n = i;
                dArray[n] = dArray[n] - X[i][j];
            }
        }
        this.R.assign(X);
    }

    @Override
    public void summarize() {
        log.debug((Object)("HKY85 Nucleotide substitution rate matrix; ts=" + this.ts + "  tv=" + this.tv + "  piA=" + this.piA + "  piC=" + this.piC + "  piG=" + this.piG + "  piT=" + this.piT));
    }
}

