/*
 * Decompiled with CFR 0.152.
 */
package calhoun.analysis.crf.features.tricycle13;

import calhoun.analysis.crf.AbstractFeatureManager;
import calhoun.analysis.crf.FeatureList;
import calhoun.analysis.crf.FeatureManagerEdge;
import calhoun.analysis.crf.ModelManager;
import calhoun.analysis.crf.features.supporting.MarkovPredictorLogprob;
import calhoun.analysis.crf.features.supporting.MaxentMotifModel;
import calhoun.analysis.crf.io.InputSequence;
import calhoun.analysis.crf.io.TrainingSequence;
import calhoun.seq.KmerHasher;
import calhoun.util.Assert;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MaxentMotifFeatures
extends AbstractFeatureManager<Character>
implements FeatureManagerEdge<Character> {
    private static final long serialVersionUID = -7659288739348604129L;
    private static final Log log = LogFactory.getLog(MaxentMotifFeatures.class);
    boolean debug = log.isDebugEnabled();
    int startIx;
    ModelManager model;
    KmerHasher h;
    boolean tieFlag = false;
    int nFeatures;
    int spanLimit = 12;
    int[] span;
    int[] offset;
    int[] tranfrom;
    int[] tranto;
    boolean dcflag;
    List<int[]> dcc;
    MarkovPredictorLogprob predictorlp;
    InputSequence<? extends Character> lastSeq;
    int lastPos;
    float[] vals;
    List<double[]> listprob;

    public MaxentMotifFeatures(List<int[]> geometry, List<int[]> dccorrection, List<int[]> markovhistory) {
        this.setThingsUp(geometry, dccorrection, markovhistory);
    }

    public MaxentMotifFeatures(List<int[]> geometry, List<int[]> dccorrection, List<int[]> markovhistory, List<int[]> flags) {
        this.tieFlag = true;
        this.setThingsUp(geometry, dccorrection, markovhistory);
    }

    private void setThingsUp(List<int[]> geometry, List<int[]> dccorrection, List<int[]> markovhistory) {
        int i;
        this.nFeatures = geometry.size();
        this.vals = new float[this.nFeatures];
        this.h = new KmerHasher(KmerHasher.ACGTother, 1);
        this.dcflag = true;
        this.predictorlp = new MarkovPredictorLogprob(markovhistory);
        this.dcc = dccorrection;
        this.span = new int[this.nFeatures];
        this.offset = new int[this.nFeatures];
        this.tranfrom = new int[this.nFeatures];
        this.tranto = new int[this.nFeatures];
        this.listprob = new ArrayList<double[]>();
        for (i = 0; i < this.nFeatures; ++i) {
            this.span[i] = geometry.get(i)[0];
            this.offset[i] = geometry.get(i)[1];
            this.tranfrom[i] = geometry.get(i)[2];
            this.tranto[i] = geometry.get(i)[3];
            Assert.a(this.span[i] <= this.spanLimit);
            int len = 1;
            for (int j = 0; j < this.span[i]; ++j) {
                len *= 4;
            }
            double[] prob = new double[len];
            this.listprob.add(prob);
        }
        Assert.a(dccorrection.size() == this.nFeatures);
        for (i = 0; i < this.nFeatures; ++i) {
            Assert.a(this.offset[i] >= 0 && this.offset[i] <= this.span[i]);
            Assert.a(dccorrection.get(i).length == this.span[i]);
        }
    }

    @Override
    public int getNumFeatures() {
        if (this.tieFlag) {
            return 1;
        }
        return this.nFeatures;
    }

    @Override
    public String getFeatureName(int featureIndex) {
        if (this.tieFlag) {
            return "tiedMaxentMotifModels";
        }
        int raw = featureIndex - this.startIx;
        String ret = "MaxentMotifModels.span" + this.span[raw] + ".offset" + this.offset[raw] + ".fromState." + this.model.getStateName(this.tranfrom[raw]) + ".toState." + this.model.getStateName(this.tranto[raw]);
        return ret;
    }

    @Override
    public void evaluateEdge(InputSequence<? extends Character> seq, int pos, int previousState, int state, FeatureList result) {
        if (pos == 0) {
            return;
        }
        if (seq != this.lastSeq || pos != this.lastPos) {
            this.lastSeq = seq;
            this.lastPos = pos;
            this.updateVals(seq, pos);
        }
        if (this.tieFlag) {
            for (int j = 0; j < this.nFeatures; ++j) {
                if (this.tranfrom[j] != previousState || this.tranto[j] != state) continue;
                result.addFeature(this.startIx, this.vals[j]);
            }
        } else {
            for (int j = 0; j < this.nFeatures; ++j) {
                if (this.tranfrom[j] != previousState || this.tranto[j] != state) continue;
                result.addFeature(this.startIx + j, this.vals[j]);
            }
        }
    }

    void updateVals(InputSequence<? extends Character> seq, int ix) {
        for (int j = 0; j < this.nFeatures; ++j) {
            int spn = this.span[j];
            int offset1 = this.offset[j];
            float val = 0.0f;
            if (ix >= offset1 && ix - offset1 + spn <= seq.length()) {
                boolean completeInformation = true;
                for (int i = 0; i < spn; ++i) {
                    int pos = ix - offset1 + i;
                    char c = seq.getX(pos).charValue();
                    if (this.h.hash(c) != 4) continue;
                    completeInformation = false;
                }
                if (completeInformation) {
                    int hash = 0;
                    for (int i = 0; i < spn; ++i) {
                        int pos = ix - offset1 + i;
                        char c = seq.getX(pos).charValue();
                        hash = hash * 4 + this.h.hash(c);
                    }
                    double exval = this.listprob.get(j)[hash];
                    if (exval > 0.0) {
                        val = (float)Math.log(exval);
                    } else {
                        log.info((Object)"Refusing to take log of zero, returning a large penalty instead.");
                        val = -4000.0f;
                    }
                    if (this.dcflag) {
                        for (int i = 0; i < spn; ++i) {
                            val -= this.predictorlp.logprob(this.dcc.get(j)[i], seq, ix - offset1 + i);
                        }
                    }
                }
            }
            this.vals[j] = val;
        }
    }

    @Override
    public void train(int startingIndex, ModelManager modelInfo, List<? extends TrainingSequence<? extends Character>> data) {
        this.startIx = startingIndex;
        this.model = modelInfo;
        log.debug((Object)"Training a maxent motif feature manager");
        for (int i = 0; i < this.nFeatures; ++i) {
            ArrayList<int[]> motifExamples = new ArrayList<int[]>();
            log.debug((Object)("Training a maxent motif feature with span " + this.span[i]));
            for (TrainingSequence<? extends Character> trainingSequence : data) {
                int len = trainingSequence.length();
                for (int ix = this.offset[i]; ix < len - this.span[i] + this.offset[i]; ++ix) {
                    if (ix <= 0 || ix >= len) continue;
                    int yprev = trainingSequence.getY(ix - 1);
                    int y = trainingSequence.getY(ix);
                    if (yprev != this.tranfrom[i] || y != this.tranto[i]) continue;
                    int[] example = new int[this.span[i]];
                    boolean completeInformation = true;
                    for (int pos = 0; pos < this.span[i]; ++pos) {
                        char c = trainingSequence.getX(ix - this.offset[i] + pos).charValue();
                        example[pos] = this.h.hash(c);
                        if (example[pos] != 4) continue;
                        completeInformation = false;
                    }
                    if (!completeInformation) continue;
                    motifExamples.add(example);
                }
            }
            this.listprob.set(i, MaxentMotifModel.trainMaxentDistributionUsingAllPairwiseConstraints(motifExamples, this.span[i], 1000, 0.01));
        }
        if (this.dcflag) {
            this.predictorlp.train(data);
        }
    }
}

