/*
 * Decompiled with CFR 0.152.
 */
package calhoun.analysis.crf.features.tricycle13;

import calhoun.analysis.crf.AbstractFeatureManager;
import calhoun.analysis.crf.CacheStrategySpec;
import calhoun.analysis.crf.FeatureList;
import calhoun.analysis.crf.FeatureManagerNode;
import calhoun.analysis.crf.ModelManager;
import calhoun.analysis.crf.io.CompositeInput;
import calhoun.analysis.crf.io.InputSequence;
import calhoun.analysis.crf.io.TrainingSequence;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PfamPhase
extends AbstractFeatureManager<CompositeInput>
implements FeatureManagerNode<CompositeInput> {
    private static final long serialVersionUID = -7659288739348604129L;
    private static final Log log = LogFactory.getLog(PfamPhase.class);
    boolean debug = log.isDebugEnabled();
    int startIx;
    ModelManager model;
    int exon1S;
    int exon2S;
    int exon3S;
    int exon1mS;
    int exon2mS;
    int exon3mS;

    @Override
    public int getNumFeatures() {
        return 1;
    }

    @Override
    public String getFeatureName(int featureIndex) {
        return "PfamPhase";
    }

    @Override
    public void evaluateNode(InputSequence<? extends CompositeInput> seq, int pos, int state, FeatureList result) {
        if (pos == seq.length() - 1) {
            return;
        }
        InputSequence<?> ppfam = seq.getComponent("ppfam");
        InputSequence<?> mpfam = seq.getComponent("mpfam");
        if (state == this.exon1S && (Integer)ppfam.getX(pos) == 1) {
            result.addFeature(this.startIx, 1.0);
        }
        if (state == this.exon2S && (Integer)ppfam.getX(pos) == 2) {
            result.addFeature(this.startIx, 1.0);
        }
        if (state == this.exon3S && (Integer)ppfam.getX(pos) == 3) {
            result.addFeature(this.startIx, 1.0);
        }
        if (state == this.exon1mS && (Integer)mpfam.getX(pos) == 1) {
            result.addFeature(this.startIx, 1.0);
        }
        if (state == this.exon2mS && (Integer)mpfam.getX(pos) == 2) {
            result.addFeature(this.startIx, 1.0);
        }
        if (state == this.exon3mS && (Integer)mpfam.getX(pos) == 3) {
            result.addFeature(this.startIx, 1.0);
        }
    }

    @Override
    public void train(int startingIndex, ModelManager modelInfo, List<? extends TrainingSequence<? extends CompositeInput>> data) {
        this.startIx = startingIndex;
        this.model = modelInfo;
        this.exon1S = this.model.getStateIndex("exon1");
        this.exon2S = this.model.getStateIndex("exon2");
        this.exon3S = this.model.getStateIndex("exon3");
        this.exon1mS = this.model.getStateIndex("exon1m");
        this.exon2mS = this.model.getStateIndex("exon2m");
        this.exon3mS = this.model.getStateIndex("exon3m");
    }

    @Override
    public CacheStrategySpec getCacheStrategy() {
        return new CacheStrategySpec(CacheStrategySpec.CacheStrategy.UNSPECIFIED);
    }
}

