/*
 * Decompiled with CFR 0.152.
 */
package calhoun.analysis.crf.io;

import calhoun.analysis.crf.io.FilenameMapper;
import calhoun.util.Assert;
import calhoun.util.FileUtil;
import java.io.File;

public class ExtensionMapper
implements FilenameMapper {
    boolean append;
    String extension;

    public boolean isAppend() {
        return this.append;
    }

    public void setAppend(boolean append) {
        this.append = append;
    }

    public String getExtension() {
        return this.extension;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    @Override
    public File mapFilename(File source) {
        String dest;
        Assert.a(this.extension != null, "Extension must be set befure mapFilename can be called.");
        if (this.append) {
            dest = source.getPath() + this.extension;
        } else {
            String[] baseAndExtension = FileUtil.getBaseAndExtension(source);
            String directory = "";
            if (source.getParent() != null) {
                directory = source.getParent() + File.separator;
            }
            dest = directory + baseAndExtension[0] + this.extension;
        }
        return new File(dest);
    }
}

