/*
 * Decompiled with CFR 0.152.
 */
package calhoun.analysis.crf.io;

import calhoun.analysis.crf.io.AllIntergenicHiddenStateReader;
import calhoun.analysis.crf.io.InputHandler;
import calhoun.analysis.crf.io.InputSequence;
import calhoun.analysis.crf.io.InputSequenceComposite;
import calhoun.analysis.crf.io.TrainingSequence;
import calhoun.analysis.crf.io.TrainingSequenceIO;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class InputHandlerBase
implements InputHandler {
    private static final long serialVersionUID = 4002620265503458109L;

    Iterator<? extends InputSequence<?>> createCompositeInput(List<Map<String, InputSequence<?>>> inputs) {
        ArrayList<InputSequenceComposite> ret = new ArrayList<InputSequenceComposite>();
        for (Map<String, InputSequence<?>> input : inputs) {
            ret.add(new InputSequenceComposite(input));
        }
        return ret.iterator();
    }

    List<? extends TrainingSequence<?>> readTrainingData(String location, String trainingLocation, TrainingSequenceIO hiddenStateReader, boolean predict) throws IOException {
        Iterator<InputSequence<?>> inputIter = this.readInputData(location);
        ArrayList<TrainingSequence<Map<String, Object>>> ret = new ArrayList<TrainingSequence<Map<String, Object>>>();
        while (inputIter.hasNext()) {
            ret.add(new TrainingSequence(inputIter.next()));
        }
        TrainingSequenceIO readerToUse = predict ? new AllIntergenicHiddenStateReader() : hiddenStateReader;
        readerToUse.readTrainingSequences(trainingLocation, ret);
        return ret;
    }
}

