/*
 * Decompiled with CFR 0.152.
 */
package calhoun.analysis.crf.io;

import calhoun.analysis.crf.io.InputSequence;
import calhoun.analysis.crf.io.InterleavedInputComponent;
import calhoun.util.Assert;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class InterleavedInputComponentBase
implements InterleavedInputComponent {
    private static final long serialVersionUID = 2972885935425621520L;
    String name = "default";

    @Override
    public List<String> getComponentNames() {
        return Collections.singletonList(this.name);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readInputSequences(String location, List<Map<String, InputSequence<?>>> inputs) throws IOException {
        BufferedReader r = new BufferedReader(new FileReader(new File(location)));
        try {
            HashMap seq = new HashMap();
            if (inputs.size() == 0) {
                boolean success;
                while (success = this.read(r, seq = new HashMap())) {
                    inputs.add(seq);
                }
            } else {
                for (Map<String, InputSequence<?>> input : inputs) {
                    boolean success = this.read(r, input);
                    Assert.a(success);
                }
                Assert.a(!this.read(r, seq));
            }
        }
        finally {
            r.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeInputSequences(String location, List<? extends Map<String, ? extends InputSequence<?>>> inputComponents) throws IOException {
        BufferedWriter w = new BufferedWriter(new FileWriter(new File(location)));
        try {
            for (Map<String, InputSequence<?>> map : inputComponents) {
                this.write(w, map);
            }
        }
        finally {
            w.close();
        }
    }
}

