/*
 * Decompiled with CFR 0.152.
 */
package calhoun.analysis.crf.io;

import calhoun.analysis.crf.io.InputSequence;
import calhoun.util.Assert;
import calhoun.util.RangeMap;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IntervalInputSequence
implements InputSequence<IntervalPosition> {
    private static final Log log = LogFactory.getLog(IntervalInputSequence.class);
    RangeMap rmplus;
    RangeMap rmminus;
    String inputName;
    int inputLength;

    public IntervalInputSequence(RangeMap rmplus, RangeMap rmminus, String inputName, int inputLength) {
        this.rmplus = rmplus;
        this.rmminus = rmminus;
        this.inputName = inputName;
        this.inputLength = inputLength;
    }

    @Override
    public IntervalPosition getX(int ix) {
        IntervalPosition ret = new IntervalPosition(ix);
        return ret;
    }

    @Override
    public int length() {
        return this.inputLength;
    }

    public IntervalInputSequence subSequence(int start, int end) {
        Assert.a(end >= start);
        Assert.a(end <= this.inputLength);
        Assert.a(start >= 1);
        RangeMap newRmplus = this.shiftedSubRangeMap(this.rmplus, start, end);
        RangeMap newRmminus = this.shiftedSubRangeMap(this.rmminus, start, end);
        return new IntervalInputSequence(newRmplus, newRmminus, this.inputName, end - start + 1);
    }

    @Override
    public InputSequence getComponent(String name) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection<String> listComponents() {
        throw new UnsupportedOperationException();
    }

    private RangeMap shiftedSubRangeMap(RangeMap rm, int start, int end) {
        Object[] rmplusList = rm.find(start - 1, end - 1).toArray();
        RangeMap newrm = new RangeMap();
        for (int i = 0; i < rmplusList.length; ++i) {
            IntervalRangeMapValue irmv = (IntervalRangeMapValue)rmplusList[i];
            IntervalRangeMapValue newirmv = new IntervalRangeMapValue(irmv.start - start + 1, irmv.end - start + 1, irmv.value);
            rm.add(newirmv.start, newirmv.end, newirmv);
        }
        return newrm;
    }

    public static class IntervalRangeMapValue {
        public int start;
        public int end;
        public double value;

        public IntervalRangeMapValue(int start, int end, double value) {
            this.start = start;
            this.end = end;
            this.value = value;
        }

        public void insertIntoRangeMap(RangeMap RM) {
            RM.add(this.start, this.end, this);
        }

        public String toStringStrand(String strand) {
            String ret = "(" + this.start + "," + this.end + "," + strand + "," + this.value + ")";
            return ret;
        }
    }

    public class IntervalPosition {
        int pos;

        public IntervalPosition(int pos) {
            this.pos = pos;
        }

        public boolean queryPlus() {
            return IntervalInputSequence.this.rmplus.find(this.pos, this.pos + 1).size() > 0;
        }

        public boolean queryMinus() {
            return IntervalInputSequence.this.rmminus.find(this.pos, this.pos + 1).size() > 0;
        }
    }
}

