/*
 * Decompiled with CFR 0.152.
 */
package calhoun.analysis.crf.io;

import calhoun.analysis.crf.features.supporting.phylogenetic.PhylogeneticTreeFelsensteinOrder;
import calhoun.analysis.crf.features.supporting.phylogenetic.RootedBinaryPhylogeneticTree;
import calhoun.analysis.crf.io.InputSequence;
import calhoun.seq.KmerHasher;
import calhoun.util.Assert;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MultipleAlignmentInputSequence
implements InputSequence<MultipleAlignmentColumn> {
    private static final Log log = LogFactory.getLog(MultipleAlignmentInputSequence.class);
    List<String> speciesNames;
    List<String> consensuses;
    RootedBinaryPhylogeneticTree tree;
    String refSpecies;
    int nSpecies;
    int consensusLength;
    KmerHasher h;
    ArrayList<Integer> ref2con;
    int[] con2refLeft;
    int[] con2refRight;
    int refSpeciesIndex = 0;
    int reflen;
    boolean ready;
    KmerHasher columnHasher;

    public MultipleAlignmentInputSequence(String refSpecies, RootedBinaryPhylogeneticTree tree) {
        this.refSpecies = refSpecies;
        this.tree = tree;
        this.nSpecies = tree.getNumSpecies();
    }

    public MultipleAlignmentInputSequence(List<String> speciesNames, List<String> consensuses, String refSpecies, RootedBinaryPhylogeneticTree tree) {
        this(refSpecies, tree);
        this.setSpeciesAndConsensuses(speciesNames, consensuses);
    }

    public int getNumSpecies() {
        return this.nSpecies;
    }

    void setSpeciesAndConsensuses(List<String> speciesNames, List<String> consensuses) {
        this.speciesNames = speciesNames;
        this.consensuses = consensuses;
        Assert.a(speciesNames.size() == consensuses.size());
        Assert.a(this.nSpecies == speciesNames.size());
        Assert.a(this.nSpecies >= 1, "Number of species was " + this.nSpecies + " and supposed to be >= 1");
        this.refSpeciesIndex = speciesNames.indexOf(this.refSpecies);
        Assert.a(this.refSpeciesIndex != -1, "Reference species ", this.refSpecies, " not found in ", StringUtils.join(speciesNames.iterator(), (char)','));
        this.columnHasher = new KmerHasher(KmerHasher.ACGTother, this.nSpecies);
        this.consensusLength = consensuses.get(this.refSpeciesIndex).length();
        for (int spec = 0; spec < this.nSpecies; ++spec) {
            Assert.a(consensuses.get(spec).length() == this.consensusLength);
        }
        this.h = new KmerHasher(KmerHasher.ACGTN, 1);
        this.reflen = 0;
        this.ref2con = new ArrayList();
        String refCon = consensuses.get(this.refSpeciesIndex);
        for (int cpos = 0; cpos < this.consensusLength; ++cpos) {
            if (!this.h.hashable(refCon.charAt(cpos))) continue;
            this.ref2con.add(cpos);
            ++this.reflen;
        }
        Assert.a(this.ref2con.size() == this.reflen);
        this.con2refLeft = new int[this.consensusLength];
        int refLeft = 0;
        for (int cpos = 0; cpos < this.consensusLength; ++cpos) {
            if (refLeft >= this.reflen - 1 || this.ref2con.get(refLeft + 1) < cpos) {
                // empty if block
            }
            this.con2refLeft[cpos] = ++refLeft;
        }
        this.con2refRight = new int[this.consensusLength];
        int refRight = this.reflen - 1;
        for (int cpos = this.consensusLength - 1; cpos >= 0; --cpos) {
            if (refRight <= 0 || this.ref2con.get(refRight - 1) > cpos) {
                // empty if block
            }
            this.con2refRight[cpos] = --refRight;
        }
        log.debug((Object)("consensus length = " + this.consensusLength + "    Reference length = " + this.reflen));
    }

    @Override
    public MultipleAlignmentColumn getX(int ix) {
        MultipleAlignmentColumn ret = new MultipleAlignmentColumn(ix);
        return ret;
    }

    @Override
    public int length() {
        return this.reflen;
    }

    @Override
    public InputSequence<?> getComponent(String name) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection<String> listComponents() {
        throw new UnsupportedOperationException();
    }

    public int con2refLeft(int cpos) {
        return this.con2refLeft[cpos];
    }

    public int con2refRight(int cpos) {
        return this.con2refRight[cpos];
    }

    public int ref2con(int pos) {
        return this.ref2con.get(pos);
    }

    public char characterInPaddedAlignment(int consensusPosition, int speciesNumber) {
        return this.consensuses.get(speciesNumber).charAt(consensusPosition);
    }

    public int numSpecies() {
        return this.nSpecies;
    }

    @Override
    public InputSequence<MultipleAlignmentColumn> subSequence(int start, int end) {
        Assert.a(start >= 1);
        Assert.a(end <= this.length());
        Assert.a(start <= end);
        int constart1 = this.ref2con(start - 1) + 1;
        int conend1 = this.ref2con(end - 1) + 1;
        ArrayList<String> newcon = new ArrayList<String>();
        for (int j = 0; j < this.nSpecies; ++j) {
            newcon.add(this.consensuses.get(j).substring(constart1 - 1, conend1));
        }
        MultipleAlignmentInputSequence MA = new MultipleAlignmentInputSequence(this.speciesNames, newcon, this.refSpecies, this.tree);
        return MA;
    }

    public List<String> getSpeciesNames() {
        return this.speciesNames;
    }

    public List<String> getConsensusSeqs() {
        return this.consensuses;
    }

    public int getColumnUniqueHash(int conpos) {
        int ret = 0;
        for (int i = 0; i < this.nSpecies; ++i) {
            ret = this.columnHasher.shiftHash(this.consensuses.get(i).charAt(conpos), ret);
        }
        return ret;
    }

    public int getConsensusLength() {
        return this.consensusLength;
    }

    public RootedBinaryPhylogeneticTree getTree() {
        return this.tree;
    }

    public PhylogeneticTreeFelsensteinOrder getFelsensteinOrder() {
        int n = this.speciesNames.size();
        String[] sn = new String[n];
        for (int j = 0; j < n; ++j) {
            sn[j] = this.speciesNames.get(j);
        }
        return this.tree.subtree(sn).getFelsensteinOrder(sn);
    }

    public class MultipleAlignmentColumn {
        private int pos;
        private int cpos;

        public MultipleAlignmentColumn(int pos) {
            this.pos = pos;
            this.cpos = MultipleAlignmentInputSequence.this.ref2con(pos);
        }

        public MultipleAlignmentInputSequence getMultipleAlignment() {
            return MultipleAlignmentInputSequence.this;
        }

        public int numSpecies() {
            return MultipleAlignmentInputSequence.this.numSpecies();
        }

        public char nucleotide(int spec) {
            return MultipleAlignmentInputSequence.this.characterInPaddedAlignment(this.cpos, spec);
        }

        public int getUniqueHash() {
            return MultipleAlignmentInputSequence.this.getColumnUniqueHash(this.pos);
        }

        public RootedBinaryPhylogeneticTree getTree() {
            return MultipleAlignmentInputSequence.this.getTree();
        }
    }
}

