/*
 * Decompiled with CFR 0.152.
 */
package calhoun.analysis.crf.io;

import calhoun.analysis.crf.io.InputSequence;
import calhoun.analysis.crf.io.OutputHandler;
import java.io.IOException;
import java.util.List;

public class OutputHandlerComposite
implements OutputHandler {
    private static final long serialVersionUID = 7923868199821973396L;
    List<OutputHandler> handlers;

    @Override
    public void setOutputLocation(String location) {
        for (OutputHandler handler : this.handlers) {
            handler.setOutputLocation(location);
        }
    }

    @Override
    public void writeOutput(InputSequence<?> sequence, int[] hiddenStates) throws IOException {
        for (OutputHandler handler : this.handlers) {
            handler.writeOutput(sequence, hiddenStates);
        }
    }

    @Override
    public void writeTestOutput(InputSequence<?> sequence, int[] truePath, int[] hiddenStates) throws IOException {
        for (OutputHandler handler : this.handlers) {
            handler.writeTestOutput(sequence, truePath, hiddenStates);
        }
    }

    @Override
    public void outputComplete() throws IOException {
        for (OutputHandler handler : this.handlers) {
            handler.outputComplete();
        }
    }

    public List<OutputHandler> getHandlers() {
        return this.handlers;
    }

    public void setHandlers(List<OutputHandler> handlers) {
        this.handlers = handlers;
    }
}

