/*
 * Decompiled with CFR 0.152.
 */
package calhoun.analysis.crf.io;

import calhoun.analysis.crf.io.TrainingSequence;
import calhoun.util.Assert;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class SequenceConverter {
    private static HashMap<String, Integer> map = new HashMap();

    public static ArrayList<ArrayList<Integer>> stateVector2StateLengths(List<? extends TrainingSequence<?>> data, int nStates) {
        ArrayList<ArrayList<Integer>> durations = new ArrayList<ArrayList<Integer>>();
        for (int j = 0; j < nStates; ++j) {
            durations.add(new ArrayList());
        }
        for (TrainingSequence<?> seq : data) {
            if (seq.length() == 0) continue;
            int oldState = seq.getY(0);
            int intervalStart = 0;
            for (int pos = 1; pos < seq.length(); ++pos) {
                int newState = seq.getY(pos);
                if (newState == oldState) continue;
                durations.get(oldState).add(pos - intervalStart);
                intervalStart = pos;
                oldState = newState;
            }
            durations.get(oldState).add(seq.length() - intervalStart);
        }
        return durations;
    }

    public static int[] convertSeqFromInterval13ToInterval29(int[] states) {
        int ctr = 0;
        for (int i = 0; i < states.length - 1; ++i) {
            int swap = 0;
            int preswap = 0;
            if (states[i] == 0 && states[i + 1] >= 1 && states[i + 1] <= 3) {
                preswap = 13;
            } else if (states[i] >= 1 && states[i] <= 3 && states[i + 1] == 0) {
                swap = 14;
            } else if (states[i] >= 1 && states[i] <= 3 && states[i + 1] >= 4 && states[i + 1] <= 6) {
                swap = 15 + (states[i + 1] - 4);
            } else if (states[i] >= 4 && states[i] <= 6 && states[i + 1] >= 1 && states[i + 1] <= 3) {
                preswap = 18 + (states[i + 1] - 1);
            } else if (states[i] == 0 && states[i + 1] >= 7 && states[i + 1] <= 9) {
                preswap = 21;
            } else if (states[i] >= 7 && states[i] <= 9 && states[i + 1] == 0) {
                swap = 22;
            } else if (states[i] >= 7 && states[i] <= 9 && states[i + 1] >= 10 && states[i + 1] <= 12) {
                swap = 23 + (states[i + 1] - 10);
            } else if (states[i] >= 10 && states[i] <= 12 && states[i + 1] >= 7 && states[i + 1] <= 9) {
                preswap = 26 + (states[i + 1] - 7);
            }
            if (swap != 0) {
                if (i != states.length - 2 && states[i + 2] == states[i + 1]) {
                    states[i + 1] = swap;
                    states[i + 2] = swap;
                } else if (i == states.length - 2) {
                    states[i + 1] = swap;
                }
                ++ctr;
                continue;
            }
            if (preswap == 0) continue;
            if (i >= 1 && states[i] == states[i - 1]) {
                states[i] = preswap;
                states[i - 1] = preswap;
                continue;
            }
            if (i != 0) continue;
            states[i] = preswap;
        }
        return states;
    }

    public static int[] convertSeqFromInterval29ToInterval13(int[] seq) {
        int len = seq.length;
        Assert.a(len >= 1);
        int prevInterval29y = -1;
        for (int pos = 0; pos < len; ++pos) {
            int interval29y = seq[pos];
            int interval13y = -1;
            if (interval29y == 13 || interval29y == 14 || interval29y == 21 || interval29y == 22) {
                interval13y = 0;
            } else if (interval29y >= 15 && interval29y <= 17) {
                interval13y = interval29y - 15 + 4;
            } else if (interval29y >= 23 && interval29y <= 25) {
                interval13y = interval29y - 23 + 10;
            } else if (interval29y >= 18 && interval29y <= 20) {
                Assert.a(prevInterval29y >= 4 && prevInterval29y <= 6);
                interval13y = prevInterval29y;
            } else if (interval29y >= 26 && interval29y <= 28) {
                if (prevInterval29y == -1) {
                    prevInterval29y = interval29y - 26 + 10;
                }
                Assert.a(prevInterval29y >= 10 && prevInterval29y <= 12, "prev is " + prevInterval29y);
                interval13y = prevInterval29y;
            } else {
                interval13y = interval29y;
            }
            Assert.a(interval13y != -1);
            Assert.a(interval13y < 13);
            seq[pos] = interval13y;
            if (interval29y >= 18 && (interval29y <= 20 || interval29y >= 26)) continue;
            prevInterval29y = interval29y;
        }
        return seq;
    }

    public static int[] convertSeqFromInterval29ToInterval13Wrong(int[] states) {
        for (int i = 0; i < states.length; ++i) {
            int swap = states[i];
            if (states[i] == 13 || states[i] == 14 || states[i] == 21 || states[i] == 22) {
                swap = 0;
            } else if (states[i] >= 15 && states[i] <= 17) {
                swap = states[i] - 15 + 4;
            } else if (states[i] >= 18 && states[i] <= 20) {
                swap = states[i] - 18 + 4;
            } else if (states[i] >= 23 && states[i] <= 25) {
                swap = states[i] - 23 + 10;
            } else if (states[i] >= 26 && states[i] <= 28) {
                swap = states[i] - 26 + 10;
            }
            Assert.a(swap >= 0 && swap <= 12);
            states[i] = swap;
        }
        return states;
    }

    public static void convertSeqFromTricycle13ToInterval13(TrainingSequence<Character> seq) {
        int len = seq.length();
        Assert.a(len >= 1);
        for (int pos = 0; pos < len; ++pos) {
            int tricycle13y = seq.getY(pos);
            int interval13y = SequenceConverter.posTricycle2interval13(pos, tricycle13y);
            seq.setY(pos, interval13y);
        }
    }

    public static String convertSeqFromTricycle13ToInterval13(String seq2) {
        char[] seq = seq2.toCharArray();
        int len = seq.length;
        Assert.a(len >= 1);
        for (int pos = 0; pos < len; ++pos) {
            int tricycle13y = SequenceConverter.char2integer13(seq[pos]);
            int interval13y = SequenceConverter.posTricycle2interval13(pos, tricycle13y);
            seq[pos] = SequenceConverter.integer132char(interval13y);
        }
        return new String(seq);
    }

    private static char integer132char(int i) {
        if (i < 10) {
            return (char)(48 + i);
        }
        if (i < 36) {
            return (char)(65 + (i - 10));
        }
        if (i < 62) {
            return (char)(97 + (i - 36));
        }
        Assert.a(false);
        return '\u0000';
    }

    private static int char2integer13(char x) {
        int temp = x - 48;
        if (!(temp >= 0 && temp <= 9 || (temp = x - 65 + 10) >= 10 && temp <= 35)) {
            temp = x - 97 + 36;
            Assert.a(temp >= 36 && temp < 62, "Offending character was '" + x);
        }
        Assert.a(temp < 13, "temp = " + temp + "  and x = " + x);
        return temp;
    }

    private static int posTricycle2interval13(int pos, int tricycle13y) {
        int interval13y = 0;
        switch (tricycle13y) {
            case 0: {
                interval13y = 0;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                interval13y = ((pos - (tricycle13y - 1)) % 3 + 3) % 3 + 1;
                break;
            }
            case 4: {
                interval13y = 6;
                break;
            }
            case 5: {
                interval13y = 5;
                break;
            }
            case 6: {
                interval13y = 4;
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                interval13y = (pos + (tricycle13y - 7) + 1) % 3 + 7;
                break;
            }
            case 10: {
                interval13y = 12;
                break;
            }
            case 11: {
                interval13y = 11;
                break;
            }
            case 12: {
                interval13y = 10;
                break;
            }
            default: {
                Assert.a(false);
            }
        }
        return interval13y;
    }

    public static void convertSeqFromInterval13ToTricycle13(TrainingSequence<Character> seq) {
        int len = seq.length();
        Assert.a(len >= 1);
        for (int pos = 0; pos < len; ++pos) {
            int interval13y = seq.getY(pos);
            int tricycle13y = SequenceConverter.posInterval2tricycle13(pos, interval13y);
            seq.setY(pos, tricycle13y);
        }
    }

    public static String convertSeqFromInterval13ToTricycle13(String seq2) {
        char[] seq = seq2.toCharArray();
        int len = seq.length;
        Assert.a(len >= 1);
        for (int pos = 0; pos < len; ++pos) {
            int interval13y = SequenceConverter.char2integer13(seq[pos]);
            int tricycle13y = SequenceConverter.posInterval2tricycle13(pos, interval13y);
            seq[pos] = SequenceConverter.integer132char(tricycle13y);
        }
        return new String(seq);
    }

    private static int posInterval2tricycle13(int pos, int interval13y) {
        int tricycle13y = 0;
        switch (interval13y) {
            case 0: {
                tricycle13y = 0;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                tricycle13y = ((pos - (interval13y - 1)) % 3 + 3) % 3 + 1;
                break;
            }
            case 4: {
                tricycle13y = 6;
                break;
            }
            case 5: {
                tricycle13y = 5;
                break;
            }
            case 6: {
                tricycle13y = 4;
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                tricycle13y = ((-pos + (interval13y - 7) + 2) % 3 + 3) % 3 + 7;
                break;
            }
            case 10: {
                tricycle13y = 12;
                break;
            }
            case 11: {
                tricycle13y = 11;
                break;
            }
            case 12: {
                tricycle13y = 10;
                break;
            }
            default: {
                Assert.a(false);
            }
        }
        return tricycle13y;
    }

    public static void convertSeqFrom13To39(TrainingSequence<Character> seq) {
        int state39;
        int i;
        SequenceConverter.setStateMap();
        if (seq.length() < 2) {
            return;
        }
        ArrayList<SeqPair> states = new ArrayList<SeqPair>();
        int seqLen = seq.length();
        int startElement = seq.getY(0);
        int startIndex = 0;
        int prevElement = seq.getY(0);
        int curElement = seq.getY(1);
        int prevState = -1;
        for (i = 2; i < seqLen; ++i) {
            int curIdx = i - 1;
            int nextElement = seq.getY(i);
            Assert.a(curElement >= 0 && curElement <= 12, "invalid character in hidden sequence, '", curElement, "'");
            if (!SequenceConverter.sameState(startElement, curElement)) {
                state39 = SequenceConverter.getState39(startElement, prevElement, curElement, prevState);
                states.add(new SeqPair(state39, curIdx - 1 - startIndex + 1));
                prevState = state39;
                startElement = curElement;
                startIndex = curIdx;
            }
            prevElement = curElement;
            curElement = nextElement;
        }
        state39 = SequenceConverter.getState39(startElement, prevElement, -1, prevState);
        states.add(new SeqPair(state39, i - 1 - startIndex + 1));
        int total = 0;
        for (i = 0; i < states.size(); ++i) {
            total += ((SeqPair)states.get((int)i)).length;
        }
        Assert.a(total == seqLen, "Sum of state lengths = " + total + ", Sequence Length = " + seqLen);
        int seqIdx = 0;
        for (i = 0; i < states.size(); ++i) {
            for (int k = 0; k < ((SeqPair)states.get((int)i)).length; ++k) {
                seq.setY(seqIdx, ((SeqPair)states.get((int)i)).state);
                ++seqIdx;
            }
        }
    }

    public static void convertSeqFrom39To13(TrainingSequence<Character> seq) {
        int j;
        int len = seq.length();
        if (len < 1) {
            return;
        }
        int[] y = new int[len];
        for (j = 0; j < len; ++j) {
            y[j] = seq.getY(j);
        }
        SequenceConverter.convertSeqFrom39To13(y);
        for (j = 0; j < len; ++j) {
            seq.setY(j, y[j]);
        }
    }

    public static void convertSeqFrom39To13(int[] seq) {
        if (seq.length < 1) {
            return;
        }
        int seqLen = seq.length;
        boolean inExon = false;
        int exonPhase = -1;
        int cur = seq[0];
        for (int i = 1; i < seqLen; ++i) {
            cur = seq[i];
            Assert.a(cur >= 0 && cur <= 38, "invalid character in hidden sequence, '", cur, "'");
            if (cur == 0) {
                inExon = false;
                continue;
            }
            if (SequenceConverter.isIntron39(cur)) {
                seq[i] = SequenceConverter.convertIntron39To13(cur);
                inExon = false;
                continue;
            }
            if (inExon) {
                seq[i] = exonPhase;
                exonPhase = SequenceConverter.incrementExonPhase(exonPhase);
                continue;
            }
            inExon = true;
            seq[i] = exonPhase = SequenceConverter.convertExon39To13(cur);
            exonPhase = SequenceConverter.incrementExonPhase(exonPhase);
        }
    }

    private static int getState39(int start, int end, int next, int prevState) {
        int state39 = -1;
        if (start == 0 && end == 0) {
            state39 = map.get("NTG");
        } else if (start == 6 && end == 6) {
            state39 = map.get("I0p");
        } else if (start == 4 && end == 4) {
            state39 = map.get("I1p");
        } else if (start == 5 && end == 5) {
            state39 = map.get("I2p");
        } else if (start == 12 && end == 12) {
            state39 = map.get("I0m");
        } else if (start == 10 && end == 10) {
            state39 = map.get("I1m");
        } else if (start == 11 && end == 11) {
            state39 = map.get("I2m");
        } else if (start == 1 && end == 3) {
            state39 = prevState == map.get("NTG") && next == 0 ? map.get("ENNp") : (prevState == map.get("NTG") ? map.get("EN0p") : (next == 0 ? map.get("E0Np").intValue() : map.get("E00p").intValue()));
        } else if (start == 1 && end == 1) {
            state39 = prevState == map.get("NTG") ? map.get("EN1p").intValue() : map.get("E01p").intValue();
        } else if (start == 1 && end == 2) {
            state39 = prevState == map.get("NTG") ? map.get("EN2p").intValue() : map.get("E02p").intValue();
        } else if (start == 2 && end == 3) {
            state39 = next == 0 ? map.get("E1Np").intValue() : map.get("E10p").intValue();
        } else if (start == 3 && end == 3) {
            state39 = next == 0 ? map.get("E2Np").intValue() : map.get("E20p").intValue();
        } else if (start == 2 && end == 1) {
            state39 = map.get("E11p");
        } else if (start == 2 && end == 2) {
            state39 = map.get("E12p");
        } else if (start == 3 && end == 1) {
            state39 = map.get("E21p");
        } else if (start == 3 && end == 2) {
            state39 = map.get("E22p");
        } else if (start == 9 && end == 7) {
            state39 = prevState == map.get("NTG") && next == 0 ? map.get("ENNm") : (prevState == map.get("NTG") ? map.get("E0Nm") : (next == 0 ? map.get("EN0m").intValue() : map.get("E00m").intValue()));
        } else if (start == 7 && end == 7) {
            state39 = next == 0 ? map.get("EN1m").intValue() : map.get("E01m").intValue();
        } else if (start == 8 && end == 7) {
            state39 = next == 0 ? map.get("EN2m").intValue() : map.get("E02m").intValue();
        } else if (start == 9 && end == 8) {
            state39 = prevState == map.get("NTG") ? map.get("E1Nm").intValue() : map.get("E10m").intValue();
        } else if (start == 9 && end == 9) {
            state39 = prevState == map.get("NTG") ? map.get("E2Nm").intValue() : map.get("E20m").intValue();
        } else if (start == 7 && end == 8) {
            state39 = map.get("E11m");
        } else if (start == 8 && end == 8) {
            state39 = map.get("E12m");
        } else if (start == 7 && end == 9) {
            state39 = map.get("E21m");
        } else if (start == 8 && end == 9) {
            state39 = map.get("E22m");
        }
        if (state39 == -1) {
            Assert.a(false, "start = " + start + "   end = " + end);
        }
        return state39;
    }

    private static boolean sameState(int state1, int state2) {
        if (state1 == state2) {
            return true;
        }
        if (SequenceConverter.isPlusExon(state1) && SequenceConverter.isPlusExon(state2)) {
            return true;
        }
        return SequenceConverter.isMinusExon(state1) && SequenceConverter.isMinusExon(state2);
    }

    private static boolean isPlusExon(int state) {
        return state == 1 || state == 2 || state == 3;
    }

    private static boolean isMinusExon(int state) {
        return state == 9 || state == 8 || state == 7;
    }

    private static int convertIntron39To13(int element) {
        if (element == map.get("I1p")) {
            return 4;
        }
        if (element == map.get("I2p")) {
            return 5;
        }
        if (element == map.get("I0p")) {
            return 6;
        }
        if (element == map.get("I1m")) {
            return 10;
        }
        if (element == map.get("I2m")) {
            return 11;
        }
        if (element == map.get("I0m")) {
            return 12;
        }
        Assert.a(false);
        return -1;
    }

    private static int convertExon39To13(int element) {
        int exonPhase = -1;
        if (SequenceConverter.getStrand39(element) == 1) {
            if (element == map.get("ENNp")) {
                exonPhase = 1;
            } else if (element == map.get("EN0p")) {
                exonPhase = 1;
            } else if (element == map.get("EN1p")) {
                exonPhase = 1;
            } else if (element == map.get("EN2p")) {
                exonPhase = 1;
            } else if (element == map.get("E00p")) {
                exonPhase = 1;
            } else if (element == map.get("E01p")) {
                exonPhase = 1;
            } else if (element == map.get("E02p")) {
                exonPhase = 1;
            } else if (element == map.get("E10p")) {
                exonPhase = 2;
            } else if (element == map.get("E11p")) {
                exonPhase = 2;
            } else if (element == map.get("E12p")) {
                exonPhase = 2;
            } else if (element == map.get("E20p")) {
                exonPhase = 3;
            } else if (element == map.get("E21p")) {
                exonPhase = 3;
            } else if (element == map.get("E22p")) {
                exonPhase = 3;
            } else if (element == map.get("E0Np")) {
                exonPhase = 1;
            } else if (element == map.get("E1Np")) {
                exonPhase = 2;
            } else if (element == map.get("E2Np")) {
                exonPhase = 3;
            }
        } else if (SequenceConverter.getStrand39(element) == -1) {
            if (element == map.get("ENNm")) {
                exonPhase = 9;
            } else if (element == map.get("EN0m")) {
                exonPhase = 9;
            } else if (element == map.get("EN1m")) {
                exonPhase = 7;
            } else if (element == map.get("EN2m")) {
                exonPhase = 8;
            } else if (element == map.get("E00m")) {
                exonPhase = 9;
            } else if (element == map.get("E01m")) {
                exonPhase = 7;
            } else if (element == map.get("E02m")) {
                exonPhase = 8;
            } else if (element == map.get("E10m")) {
                exonPhase = 9;
            } else if (element == map.get("E11m")) {
                exonPhase = 7;
            } else if (element == map.get("E12m")) {
                exonPhase = 8;
            } else if (element == map.get("E20m")) {
                exonPhase = 9;
            } else if (element == map.get("E21m")) {
                exonPhase = 7;
            } else if (element == map.get("E22m")) {
                exonPhase = 8;
            } else if (element == map.get("E0Nm")) {
                exonPhase = 9;
            } else if (element == map.get("E1Nm")) {
                exonPhase = 9;
            } else if (element == map.get("E2Nm")) {
                exonPhase = 9;
            }
        }
        if (exonPhase == -1) {
            Assert.a(false);
        }
        return exonPhase;
    }

    private static int getStrand39(int element) {
        if (7 <= element && element <= 22) {
            return 1;
        }
        if (23 <= element && element <= 38) {
            return -1;
        }
        Assert.a(false);
        return 0;
    }

    private static boolean isIntron39(int element) {
        return 1 <= element && element <= 6;
    }

    private static int incrementExonPhase(int phase) {
        if (phase == 1 || phase == 2 || phase == 3) {
            if (++phase == 4) {
                phase = 1;
            }
        } else if (phase == 9 || phase == 8 || phase == 7) {
            if (--phase == 6) {
                phase = 9;
            }
        } else {
            Assert.a(false);
        }
        return phase;
    }

    public static void writeHiddenSequenceGFF(TrainingSequence<Character> refStates, String filename) throws IOException {
        boolean inPlusGene = false;
        boolean inMinusGene = false;
        int geneNum = 0;
        geneNum = 0;
        int exonEnd = 0;
        int exonStart = 0;
        BufferedWriter fout = new BufferedWriter(new FileWriter(filename));
        for (int i = 0; i < refStates.length(); ++i) {
            int ref = refStates.getY(i);
            if (ref == 1 || ref == 2 || ref == 3) {
                if (inPlusGene) continue;
                exonStart = i + 1;
                inPlusGene = true;
                continue;
            }
            if (ref == 7 || ref == 8 || ref == 9) {
                if (inMinusGene) continue;
                exonStart = i + 1;
                inMinusGene = true;
                continue;
            }
            if (inPlusGene && (ref == 4 || ref == 5 || ref == 6)) {
                exonEnd = i;
                fout.write("XXX\tghmm\tENNp\t" + exonStart + "\t" + exonEnd + "\t0\t+\t0\tgene_" + geneNum + "\n");
                inPlusGene = false;
                continue;
            }
            if (inMinusGene && (ref == 10 || ref == 11 || ref == 12)) {
                exonEnd = i;
                fout.write("XXX\tghmm\tENNm\t" + exonStart + "\t" + exonEnd + "\t0\t-\t0\tgene_" + geneNum + "\n");
                inMinusGene = false;
                continue;
            }
            if (!inPlusGene && !inMinusGene) continue;
            exonEnd = i;
            if (inPlusGene) {
                fout.write("XXX\tghmm\tENNp\t" + exonStart + "\t" + exonEnd + "\t0\t+\t0\tgene_" + geneNum + "\n");
            } else {
                fout.write("XXX\tghmm\tENNm\t" + exonStart + "\t" + exonEnd + "\t0\t-\t0\tgene_" + geneNum + "\n");
            }
            inPlusGene = false;
            inMinusGene = false;
            ++geneNum;
        }
        ((Writer)fout).close();
    }

    public void writeHiddenSequence39GFF(TrainingSequence<Character> refStates, String filename) throws IOException {
        boolean inPlusGene = false;
        boolean inMinusGene = false;
        int geneNum = 0;
        geneNum = 0;
        int exonEnd = 0;
        int exonStart = 0;
        BufferedWriter fout = new BufferedWriter(new FileWriter(filename));
        for (int i = 0; i < refStates.length(); ++i) {
            int ref = refStates.getY(i);
            if (this.isPlusExon39(ref)) {
                if (inPlusGene) continue;
                exonStart = i + 1;
                inPlusGene = true;
                continue;
            }
            if (this.isMinusExon39(ref)) {
                if (inMinusGene) continue;
                exonStart = i + 1;
                inMinusGene = true;
                continue;
            }
            if (inPlusGene && this.isPlusIntron39(ref)) {
                exonEnd = i;
                fout.write("XXX\tghmm\t" + this.stateIdxToString(refStates.getY(exonStart)) + "\t" + exonStart + "\t" + exonEnd + "\t0\t+\t0\tgene_" + geneNum + "\n");
                inPlusGene = false;
                continue;
            }
            if (inMinusGene && this.isMinusIntron39(ref)) {
                exonEnd = i;
                fout.write("XXX\tghmm\t" + this.stateIdxToString(refStates.getY(exonStart)) + "\t" + exonStart + "\t" + exonEnd + "\t0\t-\t0\tgene_" + geneNum + "\n");
                inMinusGene = false;
                continue;
            }
            if (!inPlusGene && !inMinusGene) continue;
            exonEnd = i;
            if (inPlusGene) {
                fout.write("XXX\tghmm\t" + this.stateIdxToString(refStates.getY(exonStart)) + "\t" + exonStart + "\t" + exonEnd + "\t0\t+\t0\tgene_" + geneNum + "\n");
            } else {
                fout.write("XXX\tghmm\t" + this.stateIdxToString(refStates.getY(exonStart)) + "\t" + exonStart + "\t" + exonEnd + "\t0\t-\t0\tgene_" + geneNum + "\n");
            }
            inPlusGene = false;
            inMinusGene = false;
            ++geneNum;
        }
        ((Writer)fout).close();
    }

    private boolean isPlusExon39(int state) {
        return 7 <= state && state <= 22;
    }

    private boolean isMinusExon39(int state) {
        return 23 <= state && state <= 38;
    }

    private boolean isPlusIntron39(int state) {
        return 1 <= state && state <= 3;
    }

    private boolean isMinusIntron39(int state) {
        return 4 <= state && state <= 6;
    }

    private static void setStateMap() {
        int statenum = 0;
        map.put("NTG", new Integer(statenum));
        map.put("I0p", new Integer(++statenum));
        map.put("I1p", new Integer(++statenum));
        map.put("I2p", new Integer(++statenum));
        map.put("I0m", new Integer(++statenum));
        map.put("I1m", new Integer(++statenum));
        map.put("I2m", new Integer(++statenum));
        map.put("ENNp", new Integer(++statenum));
        map.put("EN0p", new Integer(++statenum));
        map.put("EN1p", new Integer(++statenum));
        map.put("EN2p", new Integer(++statenum));
        map.put("E00p", new Integer(++statenum));
        map.put("E01p", new Integer(++statenum));
        map.put("E02p", new Integer(++statenum));
        map.put("E10p", new Integer(++statenum));
        map.put("E11p", new Integer(++statenum));
        map.put("E12p", new Integer(++statenum));
        map.put("E20p", new Integer(++statenum));
        map.put("E21p", new Integer(++statenum));
        map.put("E22p", new Integer(++statenum));
        map.put("E0Np", new Integer(++statenum));
        map.put("E1Np", new Integer(++statenum));
        map.put("E2Np", new Integer(++statenum));
        map.put("ENNm", new Integer(++statenum));
        map.put("EN0m", new Integer(++statenum));
        map.put("EN1m", new Integer(++statenum));
        map.put("EN2m", new Integer(++statenum));
        map.put("E00m", new Integer(++statenum));
        map.put("E01m", new Integer(++statenum));
        map.put("E02m", new Integer(++statenum));
        map.put("E10m", new Integer(++statenum));
        map.put("E11m", new Integer(++statenum));
        map.put("E12m", new Integer(++statenum));
        map.put("E20m", new Integer(++statenum));
        map.put("E21m", new Integer(++statenum));
        map.put("E22m", new Integer(++statenum));
        map.put("E0Nm", new Integer(++statenum));
        map.put("E1Nm", new Integer(++statenum));
        map.put("E2Nm", new Integer(++statenum));
        ++statenum;
    }

    private String stateIdxToString(int state) {
        switch (state) {
            case 0: {
                return "NTG";
            }
            case 1: {
                return "I0p";
            }
            case 2: {
                return "I1p";
            }
            case 3: {
                return "I2p";
            }
            case 4: {
                return "I0m";
            }
            case 5: {
                return "I1m";
            }
            case 6: {
                return "I2m";
            }
            case 7: {
                return "ENNp";
            }
            case 8: {
                return "EN0p";
            }
            case 9: {
                return "EN1p";
            }
            case 10: {
                return "EN2p";
            }
            case 11: {
                return "E00p";
            }
            case 12: {
                return "E01p";
            }
            case 13: {
                return "E02p";
            }
            case 14: {
                return "E10p";
            }
            case 15: {
                return "E11p";
            }
            case 16: {
                return "E12p";
            }
            case 17: {
                return "E20p";
            }
            case 18: {
                return "E21p";
            }
            case 19: {
                return "E22p";
            }
            case 20: {
                return "E0Np";
            }
            case 21: {
                return "E1Np";
            }
            case 22: {
                return "E2Np";
            }
            case 23: {
                return "ENNm";
            }
            case 24: {
                return "EN0m";
            }
            case 25: {
                return "EN1m";
            }
            case 26: {
                return "EN2m";
            }
            case 27: {
                return "E00m";
            }
            case 28: {
                return "E01m";
            }
            case 29: {
                return "E02m";
            }
            case 30: {
                return "E10m";
            }
            case 31: {
                return "E11m";
            }
            case 32: {
                return "E12m";
            }
            case 33: {
                return "E20m";
            }
            case 34: {
                return "E21m";
            }
            case 35: {
                return "E22m";
            }
            case 36: {
                return "E0Nm";
            }
            case 37: {
                return "E1Nm";
            }
            case 38: {
                return "E2Nm";
            }
        }
        return "XXX";
    }

    private static class SeqPair {
        public int state;
        public int length;

        public SeqPair(int st, int len) {
            this.state = st;
            this.length = len;
        }
    }
}

