/*
 * Decompiled with CFR 0.152.
 */
package calhoun.analysis.crf.io;

import calhoun.analysis.crf.io.InputSequence;
import calhoun.util.Assert;
import java.util.Collection;
import java.util.HashMap;

public class TrainingSequence<A>
implements InputSequence<A> {
    private static final long serialVersionUID = -443081006327395045L;
    InputSequence<? extends A> x;
    int[] y;
    HashMap<String, TrainingSequence> componentMap;

    public TrainingSequence(InputSequence<? extends A> xArg) {
        this.x = xArg;
    }

    public TrainingSequence(InputSequence<? extends A> xArg, int[] yArg) {
        this.x = xArg;
        this.y = yArg;
        Assert.a(this.y.length == this.x.length(), "Lengths differ between input and training sequences.  Hidden = " + this.y.length + "   Observed = " + this.x.length());
    }

    public InputSequence<? extends A> getInputSequence() {
        return this.x;
    }

    public int[] getY() {
        return this.y;
    }

    public void setY(int[] hiddenStates) {
        Assert.a(hiddenStates.length == this.x.length(), "Lengths differ between input and training sequences.  Hidden = " + hiddenStates.length + "   Observed = " + this.x.length());
        this.y = hiddenStates;
    }

    public int getY(int x1) {
        return this.y[x1];
    }

    public void setY(int x, int z) {
        this.y[x] = z;
    }

    @Override
    public A getX(int ix) {
        return this.x.getX(ix);
    }

    @Override
    public int length() {
        return this.x == null ? 0 : this.x.length();
    }

    @Override
    public InputSequence<?> getComponent(String name) {
        return this.getTrainingComponent(name);
    }

    @Override
    public Collection<String> listComponents() {
        return this.x.listComponents();
    }

    public TrainingSequence getTrainingComponent(String name) {
        TrainingSequence ret;
        if (this.componentMap == null) {
            this.componentMap = new HashMap();
        }
        if ((ret = this.componentMap.get(name)) == null) {
            ret = new TrainingSequence(this.x.getComponent(name), this.y);
            this.componentMap.put(name, ret);
        }
        return ret;
    }

    @Override
    public TrainingSequence<A> subSequence(int start, int end) {
        Assert.a(start >= 1);
        Assert.a(end <= this.length());
        Assert.a(start <= end);
        int[] newdata = new int[end - start + 1];
        for (int j = 0; j < end - start + 1; ++j) {
            newdata[j] = this.y[j + start - 1];
        }
        TrainingSequence<? extends A> TS = new TrainingSequence<A>(this.x.subSequence(start, end), newdata);
        return TS;
    }

    public String toString() {
        return this.x + " + training.";
    }
}

