/*
 * Decompiled with CFR 0.152.
 */
package calhoun.analysis.crf.scoring;

import calhoun.analysis.crf.LocalPathSimilarityScore;
import calhoun.analysis.crf.io.TrainingSequence;

public class SimScoreStateAndExonBoundariesInt13
implements LocalPathSimilarityScore {
    double stateBonus = 1.0;
    double boundaryPenalty = 50.0;

    @Override
    public double evaluate(int yprev, int y, TrainingSequence<?> seq, int pos) {
        double score;
        if (pos == 0) {
            return 0.0;
        }
        int realy = seq.getY(pos);
        int realyprev = seq.getY(pos - 1);
        double d = score = y == realy ? this.stateBonus : 0.0;
        if (this.isPStart(yprev, y) ^ this.isPStart(realyprev, realy) || this.isPDon(yprev, y) ^ this.isPDon(realyprev, realy) || this.isPAcc(yprev, y) ^ this.isPAcc(realyprev, realy) || this.isPStop(yprev, y) ^ this.isPStop(realyprev, realy) || this.isMStart(yprev, y) ^ this.isMStart(realyprev, realy) || this.isMDon(yprev, y) ^ this.isMDon(realyprev, realy) || this.isMAcc(yprev, y) ^ this.isMAcc(realyprev, realy) || this.isMStop(yprev, y) ^ this.isMStop(realyprev, realy)) {
            score -= this.boundaryPenalty;
        }
        return score;
    }

    private boolean isPStart(int yprev, int y) {
        return yprev == 0 && y == 1;
    }

    private boolean isPDon(int yprev, int y) {
        if (yprev == 1 && y == 4) {
            return true;
        }
        if (yprev == 2 && y == 5) {
            return true;
        }
        return yprev == 3 && y == 6;
    }

    private boolean isPAcc(int yprev, int y) {
        if (yprev == 4 && y == 2) {
            return true;
        }
        if (yprev == 5 && y == 3) {
            return true;
        }
        return yprev == 6 && y == 1;
    }

    private boolean isPStop(int yprev, int y) {
        return yprev == 3 && y == 0;
    }

    private boolean isMStart(int yprev, int y) {
        return yprev == 7 && y == 0;
    }

    private boolean isMDon(int yprev, int y) {
        if (yprev == 11 && y == 8) {
            return true;
        }
        if (yprev == 10 && y == 7) {
            return true;
        }
        return yprev == 12 && y == 9;
    }

    private boolean isMAcc(int yprev, int y) {
        if (yprev == 9 && y == 11) {
            return true;
        }
        if (yprev == 8 && y == 10) {
            return true;
        }
        return yprev == 7 && y == 12;
    }

    private boolean isMStop(int yprev, int y) {
        return yprev == 0 && y == 9;
    }
}

