/*
 * Decompiled with CFR 0.152.
 */
package calhoun.analysis.crf.solver;

import calhoun.analysis.crf.CRFTraining;
import calhoun.analysis.crf.ModelManager;
import calhoun.analysis.crf.io.TrainingSequence;
import calhoun.util.Assert;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FixedWeightOptimizer
implements CRFTraining {
    private static final Log log = LogFactory.getLog(FixedWeightOptimizer.class);
    double[] starts;

    @Override
    public double[] optimize(ModelManager fm, List<? extends TrainingSequence<?>> data) {
        int N = fm.getNumFeatures();
        if (this.starts == null) {
            log.warn((Object)"FixedWeightOptimizer called but weights not specified; setting all weights to 1.0");
            this.starts = new double[N];
            Arrays.fill(this.starts, 1.0);
        }
        Assert.a(this.starts.length == N, "Number of specified starting weights must equal the number of Features");
        return this.starts;
    }

    public double[] getStarts() {
        return this.starts;
    }

    @Override
    public void setStarts(double[] starts) {
        this.starts = starts;
    }
}

