/*
 * Decompiled with CFR 0.152.
 */
package calhoun.analysis.crf.solver;

import calhoun.analysis.crf.FeatureList;
import calhoun.analysis.crf.ModelManager;
import calhoun.analysis.crf.io.InputSequence;
import calhoun.analysis.crf.io.TrainingSequence;
import calhoun.analysis.crf.solver.CacheProcessor;
import calhoun.analysis.crf.solver.CacheProcessorBasic;
import calhoun.util.Assert;
import java.util.List;

public class NoCachingCacheProcessor
extends CacheProcessorBasic {
    boolean allPaths;
    double[] featureSumsLocal;
    boolean[] invalidTransitions;
    DirectFeatureList result;

    public boolean isAllPaths() {
        return this.allPaths;
    }

    public void setAllPaths(boolean allPaths) {
        this.allPaths = allPaths;
    }

    @Override
    public void setTrainingData(ModelManager fm, List<? extends TrainingSequence<?>> data) {
        super.setTrainingData(fm, data);
        this.basicInit(this.allPaths);
        this.result = new DirectFeatureList();
        this.invalidTransitions = new boolean[this.modelInfo.nPotentials * this.modelInfo.totalPositions];
        this.calcFeatureSums();
    }

    @Override
    public boolean[] getInvalidTransitions() {
        return this.invalidTransitions;
    }

    @Override
    public double[] getFeatureSums() {
        return this.featureSumsLocal;
    }

    void calcFeatureSums() {
        this.featureSumsLocal = new double[this.modelInfo.nFeatures];
        for (int seqNum = 0; seqNum < this.modelInfo.nSeqs; ++seqNum) {
            TrainingSequence train = (TrainingSequence)this.data.get(seqNum);
            int len = train.length();
            short previousState = -1;
            for (int pos = 0; pos < len; ++pos) {
                this.evaluatePosition(seqNum, pos);
                short state = train.getY(pos);
                int i = 0;
                CacheProcessor.FeatureEvaluation potEval = this.evals[state];
                short index = potEval.index[i];
                while (index != -1) {
                    float val = potEval.value[i];
                    Assert.a(!Float.isNaN(val));
                    short s = index;
                    this.featureSumsLocal[s] = this.featureSumsLocal[s] + (double)val;
                    index = potEval.index[++i];
                }
                for (int trans = 0; trans < this.modelInfo.nTransitions; ++trans) {
                    if (this.modelInfo.transitionTo[trans] != state || this.modelInfo.transitionFrom[trans] != previousState) continue;
                    i = 0;
                    int pot = this.modelInfo.nStates + trans;
                    potEval = this.evals[pot];
                    index = potEval.index[i];
                    while (index != -1) {
                        float val = potEval.value[i];
                        Assert.a(!Float.isNaN(val));
                        short s = index;
                        this.featureSumsLocal[s] = this.featureSumsLocal[s] + (double)val;
                        index = potEval.index[++i];
                    }
                }
                previousState = state;
            }
        }
    }

    @Override
    public void evaluatePosition(int seqNum, int pos) {
        InputSequence seq = (InputSequence)this.data.get(seqNum);
        for (int pot = 0; pot < this.modelInfo.nPotentials; ++pot) {
            this.result.evals1 = this.evals[pot];
            this.result.position = 0;
            this.result.valid = true;
            if (pot < this.modelInfo.nStates) {
                this.fm.evaluateNode(seq, pos, pot, this.result);
            } else {
                if (pos == 0) {
                    this.result.evals1.index[0] = -1;
                    continue;
                }
                int trans = pot - this.modelInfo.nStates;
                this.fm.evaluateEdge(seq, pos, this.modelInfo.transitionFrom[trans], this.modelInfo.transitionTo[trans], this.result);
            }
            if (this.result.isValid()) {
                this.result.evals1.index[this.result.position] = -1;
                continue;
            }
            this.result.evals1.value[0] = Float.NaN;
            this.result.evals1.index[0] = Short.MIN_VALUE;
            this.result.evals1.index[1] = -1;
        }
    }

    @Override
    public void evaluateSegmentsEndingAt(int seq, int pos) {
        throw new UnsupportedOperationException();
    }

    class DirectFeatureList
    implements FeatureList {
        CacheProcessor.FeatureEvaluation evals1;
        public int position;
        boolean valid;

        @Override
        public void addFeature(int index, double val) {
            this.evals1.index[this.position] = (short)index;
            this.evals1.value[this.position++] = (float)val;
        }

        @Override
        public boolean isValid() {
            return this.valid;
        }

        @Override
        public void invalidate() {
            this.valid = false;
        }
    }
}

